/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class YGenericHub {
    protected int _hubidx;
    protected long _notifyTrigger = 0L;
    protected Object _notifyHandle = null;
    protected long _devListValidity = 500L;
    protected long _devListExpires = 0L;
    protected HashMap<Integer, String> _serialByYdx = new HashMap();
    protected HashMap<String, YDevice> _devices = new HashMap();

    public YGenericHub(int idx) {
        this._hubidx = idx;
    }

    public abstract void release();

    public abstract String getRootUrl();

    public abstract boolean isSameRootUrl(String var1);

    public abstract void startNotifications() throws YAPI_Exception;

    public abstract void stopNotifications();

    protected void updateFromWpAndYp(ArrayList<WPEntry> whitePages, HashMap<String, ArrayList<YPEntry>> yellowPages) throws YAPI_Exception {
        String serial;
        ArrayList<YDevice> toRemove = new ArrayList<YDevice>(this._devices.values());
        for (WPEntry wp : whitePages) {
            serial = wp.getSerialNumber();
            if (this._devices.containsKey(serial)) {
                YDevice currdev = this._devices.get(serial);
                if (!currdev.getLogicalName().equals(wp.getLogicalName())) {
                    currdev.refresh();
                    YAPI.pushPlugEvent(YAPI.PlugEvent.Event.CHANGE, serial);
                } else if (currdev.getBeacon() > 0 != wp.getBeacon() > 0) {
                    currdev.refresh();
                }
                toRemove.remove(currdev);
                continue;
            }
            YDevice dev = new YDevice(this, wp, yellowPages);
            this._devices.put(serial, dev);
            YAPI.pushPlugEvent(YAPI.PlugEvent.Event.PLUG, serial);
            YAPI.Log("HUB: device " + serial + " has been pluged\n");
        }
        for (YDevice dev : toRemove) {
            serial = dev.getSerialNumber();
            YAPI.pushPlugEvent(YAPI.PlugEvent.Event.UNPLUG, serial);
            YAPI.Log("HUB: device " + serial + " has been unpluged\n");
            this._devices.remove(serial);
        }
    }

    abstract void updateDeviceList(boolean var1) throws YAPI_Exception;

    public abstract byte[] devRequest(YDevice var1, String var2, byte[] var3, Boolean var4) throws YAPI_Exception;
}

