/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFunction;
import java.util.HashMap;
import java.util.Iterator;

class YFunctionType {
    private String _className;
    private HashMap<String, YFunction> _connectedFns;
    private HashMap<String, YFunction> _requestedFns;
    private HashMap<String, String> _hwIdByName;
    private HashMap<String, String> _nameByHwId;
    private HashMap<String, String> _valueByHwId;

    public YFunctionType(String classname) {
        this._className = classname;
        this._connectedFns = new HashMap();
        this._requestedFns = new HashMap();
        this._hwIdByName = new HashMap();
        this._nameByHwId = new HashMap();
        this._valueByHwId = new HashMap();
    }

    public boolean reindexFunction(String hwid, String name, String val) {
        String currname = "";
        boolean res = false;
        if (this._nameByHwId.containsKey(hwid)) {
            currname = this._nameByHwId.get(hwid);
        }
        if (currname.equals("")) {
            if (!name.equals("")) {
                this._nameByHwId.put(hwid, name);
                res = true;
            }
        } else if (!currname.equals(name)) {
            if (this._hwIdByName.get(currname).equals(hwid)) {
                this._hwIdByName.remove(currname);
            }
            if (!name.equals("")) {
                this._nameByHwId.put(hwid, name);
            } else {
                this._nameByHwId.remove(hwid);
            }
            res = true;
        }
        if (!name.equals("")) {
            this._hwIdByName.put(name, hwid);
        }
        if (val != null) {
            this._valueByHwId.put(hwid, val);
        } else if (!this._valueByHwId.containsKey(hwid)) {
            this._valueByHwId.put(hwid, "");
        }
        return res;
    }

    public void forgetFunction(String hwid) {
        if (this._nameByHwId.containsKey(hwid)) {
            String currname = this._nameByHwId.get(hwid);
            if (!currname.equals("") && this._hwIdByName.get(currname).equals(hwid)) {
                this._hwIdByName.remove(currname);
            }
            this._nameByHwId.remove(hwid);
        }
        if (this._valueByHwId.containsKey(hwid)) {
            this._valueByHwId.remove(hwid);
        }
    }

    public HWID resolve(String func) throws YAPI_Exception {
        HWID hwid;
        int dotpos = func.indexOf(46);
        if (dotpos < 0) {
            if (this._hwIdByName.containsKey(func)) {
                return new HWID(this._hwIdByName.get(func));
            }
            func = func + String.format(".%c%s", Character.valueOf(Character.toLowerCase(this._className.charAt(0))), this._className.substring(1));
        }
        if (this._valueByHwId.containsKey((hwid = new HWID(func)).toString())) {
            return hwid;
        }
        if (hwid.module.length() > 0) {
            YDevice dev = YAPI.getDevice(hwid.module);
            if (dev == null) {
                throw new YAPI_Exception(-4, "Device [" + hwid.module + "] not online");
            }
            String serial = dev.getSerialNumber();
            hwid = new HWID(serial, hwid.function);
            if (this._valueByHwId.containsKey(hwid.toString())) {
                return hwid;
            }
            int nfun = dev.functionCount();
            for (int i = 0; i < nfun; ++i) {
                String name;
                hwid = new HWID(serial, dev.functionId(i));
                if (!this._nameByHwId.containsKey(hwid.toString()) || !(name = this._nameByHwId.get(hwid.toString())).equals(hwid.function)) continue;
                return hwid;
            }
        } else {
            for (String hwid_str : this._connectedFns.keySet()) {
                HWID tmpid = new HWID(hwid_str);
                if (!tmpid.function.equals(hwid.function)) continue;
                return tmpid;
            }
        }
        throw new YAPI_Exception(-4, "No function [" + hwid.function + "] found on device [" + hwid.module + "]");
    }

    public HWID friendlyName(String func) throws YAPI_Exception {
        HWID hwid = this.resolve(func);
        if (this._className.equals("Module")) {
            String module = hwid.module;
            if (this._nameByHwId.containsKey(hwid.toString())) {
                module = this._nameByHwId.get(hwid.toString());
            }
            return new HWID(module, "module");
        }
        YFunctionType mod_ftype = YAPI.getFnByType("Module");
        HWID modId = mod_ftype.friendlyName(hwid.module);
        String function = hwid.function;
        if (this._nameByHwId.containsKey(hwid.toString())) {
            function = this._nameByHwId.get(hwid.toString());
        }
        return new HWID(modId.module, function);
    }

    public void setFunction(String func, YFunction yfunc) {
        try {
            HWID hwid = this.resolve(func);
            this._connectedFns.put(hwid.toString(), yfunc);
        }
        catch (YAPI_Exception ex) {
            this._requestedFns.put(func, yfunc);
        }
    }

    public YFunction getFunction(String func) {
        block4: {
            try {
                HWID hwid = this.resolve(func);
                if (this._connectedFns.containsKey(hwid)) {
                    return this._connectedFns.get(hwid);
                }
                if (this._requestedFns.containsKey(func)) {
                    YFunction req_fn = this._requestedFns.get(func);
                    this._connectedFns.put(hwid.toString(), req_fn);
                    this._requestedFns.remove(func);
                    return req_fn;
                }
            }
            catch (YAPI_Exception ex) {
                if (!this._requestedFns.containsKey(func)) break block4;
                return this._requestedFns.get(func);
            }
        }
        return null;
    }

    public void setFunctionValue(String hwid, String pubval) {
        YFunction conn_fn;
        if (this._connectedFns.containsKey(hwid) && (conn_fn = this._connectedFns.get(hwid)).hasCallbackRegistered() && (!this._valueByHwId.containsKey(hwid) || !this._valueByHwId.get(hwid).equals(pubval))) {
            YAPI.addValueEvent(conn_fn, pubval);
        }
        this._valueByHwId.put(hwid, pubval);
    }

    public String getFunctionValue(String hwid) {
        return this._valueByHwId.get(hwid);
    }

    public String getFirstHardwareId() {
        Iterator<String> i$ = this._valueByHwId.keySet().iterator();
        if (i$.hasNext()) {
            String key = i$.next();
            return key;
        }
        return null;
    }

    public String getNextHardwareId(String hwid) {
        for (String iter_hwid : this._valueByHwId.keySet()) {
            if (hwid.equals("!")) {
                return iter_hwid;
            }
            if (!hwid.equals(iter_hwid)) continue;
            hwid = "!";
        }
        return null;
    }

    public class HWID {
        public String module;
        public String function;

        public HWID(String module, String function) {
            this.module = module;
            this.function = function;
        }

        public HWID(String full_hwid) {
            int pos = full_hwid.indexOf(46);
            this.module = full_hwid.substring(0, pos);
            this.function = full_hwid.substring(pos + 1);
        }

        public String toString() {
            return this.module + "." + this.function;
        }
    }
}

