/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFunctionType;
import com.yoctopuce.YoctoAPI.YModule;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YFunction {
    public static final String FUNCTIONDESCRIPTOR_INVALID = "!INVALID!";
    protected String _className;
    protected String _func;
    protected int _lastErrorType;
    protected String _lastErrorMsg;
    protected long _expiration;
    protected HashMap<String, String> _cache;
    protected Object _userData;
    protected UpdateCallback _valueCallback;

    public YFunction(String classname, String func) {
        this._className = classname;
        this._func = func;
        this._lastErrorType = 0;
        this._lastErrorMsg = "";
        this._expiration = 0L;
        this._cache = new HashMap();
        this._userData = null;
        this._valueCallback = null;
        YAPI.setFunction(classname, func, this);
    }

    public String describe() {
        try {
            String hwid = YAPI.resolveFunction(this._className, this._func);
            return this._className + "(" + this._func + ")=" + hwid;
        }
        catch (YAPI_Exception yAPI_Exception) {
            return this._className + "(" + this._func + ")=unresolved";
        }
    }

    public String get_hardwareId() throws YAPI_Exception {
        return YAPI.resolveFunction(this._className, this._func);
    }

    public String getHardwareId() throws YAPI_Exception {
        return YAPI.resolveFunction(this._className, this._func);
    }

    public String get_functionId() throws YAPI_Exception {
        String hwid = this.get_hardwareId();
        int pos = hwid.indexOf(46);
        return hwid.substring(pos + 1);
    }

    public String getFunctionId() throws YAPI_Exception {
        return this.get_functionId();
    }

    public String get_friendlyName() throws YAPI_Exception {
        YFunctionType ftype = YAPI.getFnByType(this._className);
        return ftype.friendlyName(this._func).toString();
    }

    public String getFriendlyName() throws YAPI_Exception {
        return this.get_friendlyName();
    }

    public String toString() {
        return this.describe();
    }

    protected Object _getAttr(String attr) throws YAPI_Exception {
        if (this._expiration <= YAPI.GetTickCount()) {
            this.load(YAPI.DefaultCacheValidity);
        }
        if (!this._cache.containsKey(attr)) {
            throw new YAPI_Exception(-5, "No such attribute " + attr + " in function");
        }
        return this._cache.get(attr);
    }

    protected Object _getFixedAttr(String attr) throws YAPI_Exception {
        if (this._expiration == 0L) {
            this.load(YAPI.DefaultCacheValidity);
        }
        if (!this._cache.containsKey(attr)) {
            throw new YAPI_Exception(-5, "No such attribute " + attr + " in function");
        }
        return this._cache.get(attr);
    }

    protected void _setAttr(String attr, String newval) throws YAPI_Exception {
        String extra;
        if (newval == null) {
            throw new YAPI_Exception(-2, "Undefined value to set for attribute " + attr);
        }
        try {
            String attrname = URLEncoder.encode(attr, "ISO-8859-1");
            extra = "/" + attrname + "?" + attrname + "=" + URLEncoder.encode(newval, "ISO-8859-1");
            extra = extra.replaceAll("%21", "!").replaceAll("%23", "#").replaceAll("%24", "$").replaceAll("%27", "'").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2C", ",").replaceAll("%2F", "/").replaceAll("%3A", ":").replaceAll("%3B", ";").replaceAll("%3F", "?").replaceAll("%40", "@").replaceAll("%5B", "[").replaceAll("%5D", "]");
        }
        catch (UnsupportedEncodingException ex) {
            throw new YAPI_Exception(-2, "Unsupported Encoding");
        }
        YAPI.funcRequest(this._className, this._func, extra);
        if (this._expiration != 0L) {
            this._expiration = YAPI.GetTickCount();
        }
    }

    private byte[] _request(String req_first_line, byte[] req_head_and_body) throws YAPI_Exception {
        YDevice dev = YAPI.funcGetDevice(this._className, this._func);
        return dev.requestHTTP(req_first_line, req_head_and_body, false);
    }

    protected int _upload(String path, byte[] content) throws YAPI_Exception {
        String boundary;
        Random randomGenerator = new Random();
        String request = "POST /upload.html HTTP/1.1\r\n";
        String mp_header = "Content-Disposition: form-data; name=\"" + path + "\"; filename=\"api\"\r\n" + "Content-Type: application/octet-stream\r\n" + "Cobntent-Transfer-Encoding: binary\r\n\r\n";
        while (mp_header.indexOf(boundary = String.format("Zz%06xzZ", randomGenerator.nextInt(0x1000000))) >= 0 && YAPI._find_in_bytes(content, boundary.getBytes()) >= 0) {
        }
        String header_start = "Content-Type: multipart/form-data; boundary=" + boundary + "\r\n\r\n--" + boundary + "\r\n" + mp_header;
        String header_stop = "\r\n--" + boundary + "--\r\n";
        byte[] head_body = new byte[header_start.length() + content.length + header_stop.length()];
        int pos = 0;
        int len = header_start.length();
        System.arraycopy(header_start.getBytes(), 0, head_body, pos, len);
        pos += len;
        len = content.length;
        System.arraycopy(content, 0, head_body, pos, len);
        pos += len;
        len = header_stop.length();
        System.arraycopy(header_stop.getBytes(), 0, head_body, pos, len);
        this._request(request, head_body);
        return 0;
    }

    protected int _upload(String pathname, String content) throws YAPI_Exception {
        try {
            return this._upload(pathname, content.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new YAPI_Exception(-2, e.getLocalizedMessage());
        }
    }

    protected byte[] _download(String url) throws YAPI_Exception {
        String request = "GET /" + url + " HTTP/1.1\r\n\r\n";
        return this._request(request, null);
    }

    protected String _json_get_key(byte[] json, String key) throws YAPI_Exception {
        JSONObject obj = null;
        try {
            obj = new JSONObject(new String(json, "ISO-8859-1"));
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        if (obj.has(key)) {
            try {
                return obj.getString(key);
            }
            catch (JSONException ex) {
                throw new YAPI_Exception(-8, ex.getLocalizedMessage());
            }
        }
        throw new YAPI_Exception(-2, "No key " + key + "in JSON struct");
    }

    protected ArrayList<String> _json_get_array(byte[] json) throws YAPI_Exception {
        JSONArray array = null;
        try {
            array = new JSONArray(new String(json, "ISO-8859-1"));
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            try {
                list.add(array.get(i).toString());
                continue;
            }
            catch (JSONException ex) {
                throw new YAPI_Exception(-8, ex.getLocalizedMessage());
            }
        }
        return list;
    }

    protected boolean hasCallbackRegistered() {
        return this._valueCallback != null;
    }

    void advertiseValue(String newvalue) {
        if (this._valueCallback != null) {
            this._valueCallback.yNewValue(this, newvalue);
        }
    }

    public boolean isOnline() {
        if (this._expiration > YAPI.GetTickCount()) {
            return true;
        }
        try {
            this.load(YAPI.DefaultCacheValidity);
        }
        catch (YAPI_Exception ex) {
            return false;
        }
        return true;
    }

    public int get_errorType() {
        return this._lastErrorType;
    }

    public int getErrorType() {
        return this._lastErrorType;
    }

    public int errorType() {
        return this._lastErrorType;
    }

    public int errType() {
        return this._lastErrorType;
    }

    public String get_errorMessage() {
        return this._lastErrorMsg;
    }

    public String getErrorMessage() {
        return this._lastErrorMsg;
    }

    public String errorMessage() {
        return this._lastErrorMsg;
    }

    public String errMessage() {
        return this._lastErrorMsg;
    }

    public int load(long msValidity) throws YAPI_Exception {
        this._cache = YAPI.funcRequest(this._className, this._func, "");
        this._expiration = YAPI.GetTickCount() + msValidity;
        return 0;
    }

    public YModule get_module() {
        int dotidx;
        String hwid = this._func;
        if (hwid.indexOf(46) == -1) {
            try {
                hwid = YAPI.resolveFunction(this._className, this._func);
            }
            catch (YAPI_Exception ex) {
                // empty catch block
            }
        }
        if ((dotidx = hwid.indexOf(46)) >= 0) {
            return YModule.FindModule(hwid.substring(0, dotidx));
        }
        try {
            if (this.load(YAPI.DefaultCacheValidity) == 0) {
                hwid = YAPI.resolveFunction(this._className, this._func);
            }
        }
        catch (YAPI_Exception yAPI_Exception) {
            // empty catch block
        }
        dotidx = hwid.indexOf(46);
        if (dotidx >= 0) {
            return YModule.FindModule(hwid.substring(0, dotidx));
        }
        return YModule.FindModule("module_of_" + this._className + "_" + this._func);
    }

    public YModule getModule() {
        return this.get_module();
    }

    public YModule module() {
        return this.get_module();
    }

    public String get_functionDescriptor() {
        String hwid = this._func;
        int dotidx = hwid.indexOf(46);
        if (dotidx < 0) {
            try {
                hwid = YAPI.resolveFunction(this._className, this._func);
            }
            catch (YAPI_Exception yAPI_Exception) {
                // empty catch block
            }
        }
        if ((dotidx = hwid.indexOf(46)) >= 0) {
            return hwid;
        }
        return FUNCTIONDESCRIPTOR_INVALID;
    }

    public String getFunctionDescriptor() {
        return this.get_functionDescriptor();
    }

    public String functionDescriptor() {
        return this.get_functionDescriptor();
    }

    public Object get_userData() {
        return this._userData;
    }

    public Object getUserData() {
        return this.get_userData();
    }

    public Object userData() {
        return this.get_userData();
    }

    public void set_userData(Object data) {
        this._userData = data;
    }

    public void setUserData(Object data) {
        this.set_userData(data);
    }

    public void registerValueCallback(UpdateCallback callback) {
        this._valueCallback = callback;
        if (callback != null && this.isOnline()) {
            try {
                String newval = this.get_advertisedValue();
                if (!newval.equals("") && !newval.equals("!INVALDI!")) {
                    callback.yNewValue(this, newval);
                }
            }
            catch (YAPI_Exception yAPI_Exception) {
                // empty catch block
            }
        }
    }

    String get_advertisedValue() throws YAPI_Exception {
        throw new UnsupportedOperationException("Should be overridden by subclass");
    }

    public static interface UpdateCallback {
        public void yNewValue(YFunction var1, String var2);
    }
}

