/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDisplayLayer;
import com.yoctopuce.YoctoAPI.YFunction;

public class YDisplay
extends YFunction {
    private UpdateCallback _valueCallbackDisplay;
    public static final String LOGICALNAME_INVALID = "!INVALID!";
    public static final String ADVERTISEDVALUE_INVALID = "!INVALID!";
    public static final int POWERSTATE_OFF = 0;
    public static final int POWERSTATE_ON = 1;
    public static final int POWERSTATE_INVALID = -1;
    public static final String STARTUPSEQ_INVALID = "!INVALID!";
    public static final int BRIGHTNESS_INVALID = -1;
    public static final int ORIENTATION_LEFT = 0;
    public static final int ORIENTATION_UP = 1;
    public static final int ORIENTATION_RIGHT = 2;
    public static final int ORIENTATION_DOWN = 3;
    public static final int ORIENTATION_INVALID = -1;
    public static final int DISPLAYWIDTH_INVALID = -1;
    public static final int DISPLAYHEIGHT_INVALID = -1;
    public static final int DISPLAYTYPE_MONO = 0;
    public static final int DISPLAYTYPE_GRAY = 1;
    public static final int DISPLAYTYPE_RGB = 2;
    public static final int DISPLAYTYPE_INVALID = -1;
    public static final int LAYERWIDTH_INVALID = -1;
    public static final int LAYERHEIGHT_INVALID = -1;
    public static final int LAYERCOUNT_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    private YDisplayLayer[] _allDisplayLayers = null;
    private Boolean _recording = false;
    private String _sequence;

    public String get_logicalName() throws YAPI_Exception {
        String json_val = (String)this._getAttr("logicalName");
        return json_val;
    }

    public String getLogicalName() throws YAPI_Exception {
        return this.get_logicalName();
    }

    public int set_logicalName(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("logicalName", rest_val);
        return 0;
    }

    public int setLogicalName(String newval) throws YAPI_Exception {
        return this.set_logicalName(newval);
    }

    public String get_advertisedValue() throws YAPI_Exception {
        String json_val = (String)this._getAttr("advertisedValue");
        return json_val;
    }

    public String getAdvertisedValue() throws YAPI_Exception {
        return this.get_advertisedValue();
    }

    public int get_powerState() throws YAPI_Exception {
        String json_val = (String)this._getAttr("powerState");
        return Integer.parseInt(json_val);
    }

    public int getPowerState() throws YAPI_Exception {
        return this.get_powerState();
    }

    public int set_powerState(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("powerState", rest_val);
        return 0;
    }

    public int setPowerState(int newval) throws YAPI_Exception {
        return this.set_powerState(newval);
    }

    public String get_startupSeq() throws YAPI_Exception {
        String json_val = (String)this._getAttr("startupSeq");
        return json_val;
    }

    public String getStartupSeq() throws YAPI_Exception {
        return this.get_startupSeq();
    }

    public int set_startupSeq(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("startupSeq", rest_val);
        return 0;
    }

    public int setStartupSeq(String newval) throws YAPI_Exception {
        return this.set_startupSeq(newval);
    }

    public int get_brightness() throws YAPI_Exception {
        String json_val = (String)this._getAttr("brightness");
        return Integer.parseInt(json_val);
    }

    public int getBrightness() throws YAPI_Exception {
        return this.get_brightness();
    }

    public int set_brightness(int newval) throws YAPI_Exception {
        String rest_val = Long.toString(newval);
        this._setAttr("brightness", rest_val);
        return 0;
    }

    public int setBrightness(int newval) throws YAPI_Exception {
        return this.set_brightness(newval);
    }

    public int get_orientation() throws YAPI_Exception {
        String json_val = (String)this._getAttr("orientation");
        return Integer.parseInt(json_val);
    }

    public int getOrientation() throws YAPI_Exception {
        return this.get_orientation();
    }

    public int set_orientation(int newval) throws YAPI_Exception {
        String rest_val = Long.toString(newval);
        this._setAttr("orientation", rest_val);
        return 0;
    }

    public int setOrientation(int newval) throws YAPI_Exception {
        return this.set_orientation(newval);
    }

    public int get_displayWidth() throws YAPI_Exception {
        String json_val = (String)this._getAttr("displayWidth");
        return Integer.parseInt(json_val);
    }

    public int getDisplayWidth() throws YAPI_Exception {
        return this.get_displayWidth();
    }

    public int get_displayHeight() throws YAPI_Exception {
        String json_val = (String)this._getAttr("displayHeight");
        return Integer.parseInt(json_val);
    }

    public int getDisplayHeight() throws YAPI_Exception {
        return this.get_displayHeight();
    }

    public int get_displayType() throws YAPI_Exception {
        String json_val = (String)this._getFixedAttr("displayType");
        return Integer.parseInt(json_val);
    }

    public int getDisplayType() throws YAPI_Exception {
        return this.get_displayType();
    }

    public int get_layerWidth() throws YAPI_Exception {
        String json_val = (String)this._getFixedAttr("layerWidth");
        return Integer.parseInt(json_val);
    }

    public int getLayerWidth() throws YAPI_Exception {
        return this.get_layerWidth();
    }

    public int get_layerHeight() throws YAPI_Exception {
        String json_val = (String)this._getFixedAttr("layerHeight");
        return Integer.parseInt(json_val);
    }

    public int getLayerHeight() throws YAPI_Exception {
        return this.get_layerHeight();
    }

    public int get_layerCount() throws YAPI_Exception {
        String json_val = (String)this._getFixedAttr("layerCount");
        return Integer.parseInt(json_val);
    }

    public int getLayerCount() throws YAPI_Exception {
        return this.get_layerCount();
    }

    public String get_command() throws YAPI_Exception {
        String json_val = (String)this._getAttr("command");
        return json_val;
    }

    public String getCommand() throws YAPI_Exception {
        return this.get_command();
    }

    public int set_command(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("command", rest_val);
        return 0;
    }

    public int setCommand(String newval) throws YAPI_Exception {
        return this.set_command(newval);
    }

    public int resetAll() throws YAPI_Exception {
        this.flushLayers();
        this.resetHiddenLayerFlags();
        return this.sendCommand("Z");
    }

    public int fade(int brightness, int duration) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("+%d,%d", brightness, duration));
    }

    public int newSequence() throws YAPI_Exception {
        this.flushLayers();
        this._sequence = "";
        this._recording = true;
        return 0;
    }

    public int saveSequence(String sequenceName) throws YAPI_Exception {
        this.flushLayers();
        this._recording = false;
        this._upload(sequenceName, this._sequence);
        this._sequence = String.format("", new Object[0]);
        return 0;
    }

    public int playSequence(String sequenceName) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("S%s", sequenceName));
    }

    public int pauseSequence(int delay_ms) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("W%d", delay_ms));
    }

    public int stopSequence() throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand("S");
    }

    public int upload(String pathname, byte[] content) throws YAPI_Exception {
        return this._upload(pathname, content);
    }

    public int copyLayerContent(int srcLayerId, int dstLayerId) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("o%d,%d", srcLayerId, dstLayerId));
    }

    public int swapLayerContent(int layerIdA, int layerIdB) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format("E%d,%d", layerIdA, layerIdB));
    }

    public YDisplay nextDisplay() {
        String next_hwid = YAPI.getNextHardwareId(this._className, this._func);
        if (next_hwid == null) {
            return null;
        }
        return YDisplay.FindDisplay(next_hwid);
    }

    public static YDisplay FindDisplay(String func) {
        YFunction yfunc = YAPI.getFunction("Display", func);
        if (yfunc != null) {
            return (YDisplay)yfunc;
        }
        return new YDisplay(func);
    }

    public static YDisplay FirstDisplay() {
        String next_hwid = YAPI.getFirstHardwareId("Display");
        if (next_hwid == null) {
            return null;
        }
        return YDisplay.FindDisplay(next_hwid);
    }

    private YDisplay(String func) {
        super("Display", func);
    }

    void advertiseValue(String newvalue) {
        super.advertiseValue(newvalue);
        if (this._valueCallbackDisplay != null) {
            this._valueCallbackDisplay.yNewValue(this, newvalue);
        }
    }

    protected boolean hasCallbackRegistered() {
        return super.hasCallbackRegistered() || this._valueCallbackDisplay != null;
    }

    public void registerValueCallback(UpdateCallback callback) {
        this._valueCallbackDisplay = callback;
        if (callback != null && this.isOnline()) {
            try {
                String newval = this.get_advertisedValue();
                if (!newval.equals("") && !newval.equals("!INVALDI!")) {
                    callback.yNewValue(this, newval);
                }
            }
            catch (YAPI_Exception yAPI_Exception) {
                // empty catch block
            }
        }
    }

    public synchronized YDisplayLayer get_displayLayer(int layerId) throws YAPI_Exception {
        if (this._allDisplayLayers == null) {
            int nb_display_layer = this.get_layerCount();
            this._allDisplayLayers = new YDisplayLayer[nb_display_layer];
            for (int i = 0; i < nb_display_layer; ++i) {
                this._allDisplayLayers[i] = new YDisplayLayer(this, i);
            }
        }
        if (layerId < 0 || layerId >= this._allDisplayLayers.length) {
            throw new YAPI_Exception(-2, "Invalid layerId");
        }
        return this._allDisplayLayers[layerId];
    }

    public synchronized int flushLayers() throws YAPI_Exception {
        if (this._allDisplayLayers != null) {
            for (int i = 0; i < this._allDisplayLayers.length; ++i) {
                this._allDisplayLayers[i].flush_now();
            }
        }
        return 0;
    }

    public synchronized void resetHiddenLayerFlags() throws YAPI_Exception {
        if (this._allDisplayLayers != null) {
            for (int i = 0; i < this._allDisplayLayers.length; ++i) {
                this._allDisplayLayers[i].resetHiddenFlag();
            }
        }
    }

    public synchronized int sendCommand(String cmd) throws YAPI_Exception {
        if (!this._recording.booleanValue()) {
            return this.set_command(cmd);
        }
        this._sequence = this._sequence + cmd + "\n";
        return 0;
    }

    public static interface UpdateCallback {
        public void yNewValue(YDisplay var1, String var2);
    }
}

