/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YDevice {
    public static ArrayList<YDevice> _devCache = new ArrayList();
    private YGenericHub _hub;
    private WPEntry _wpRec;
    private long _cache_expiration;
    private String _cache_json;
    private HashMap<Integer, String> _functions_funcid;
    private HashMap<Integer, String> _functions_name;

    YDevice(YGenericHub hub, WPEntry wpRec, HashMap<String, ArrayList<YPEntry>> ypRecs) throws YAPI_Exception {
        this._hub = hub;
        this._wpRec = wpRec;
        this._cache_expiration = 0L;
        this._cache_json = "";
        this._functions_funcid = new HashMap();
        this._functions_name = new HashMap();
        for (String categ : ypRecs.keySet()) {
            for (YPEntry rec : ypRecs.get(categ)) {
                if (!rec.getSerial().equals(wpRec.getSerialNumber())) continue;
                int funydx = rec.getIndex();
                this._functions_funcid.put(funydx, rec.getFuncId());
                this._functions_name.put(funydx, rec.getLogicalName());
            }
        }
        YAPI.reindexDevice(this);
    }

    public String getSerialNumber() {
        return this._wpRec.getSerialNumber();
    }

    public String getLogicalName() {
        return this._wpRec.getLogicalName();
    }

    public String getProductName() {
        return this._wpRec.getProductName();
    }

    public int getProductId() {
        return this._wpRec.getProductId();
    }

    String getRelativePath() {
        return this._wpRec.getNetworkUrl();
    }

    public int getBeacon() {
        return this._wpRec.getBeacon();
    }

    public int getDevYdx() {
        return this._wpRec.getIndex();
    }

    public String requestAPI() throws YAPI_Exception {
        if (this._cache_expiration > YAPI.GetTickCount()) {
            return this._cache_json;
        }
        String yreq = new String(this.requestHTTP("GET /api.json", null, false));
        this._cache_expiration = YAPI.GetTickCount() + (long)YAPI.DefaultCacheValidity;
        this._cache_json = yreq;
        return yreq;
    }

    public int refresh() throws YAPI_Exception {
        String result = this.requestAPI();
        Boolean reindex = false;
        try {
            JSONObject loadval = new JSONObject(result);
            this._cache_expiration = YAPI.GetTickCount() + (long)YAPI.DefaultCacheValidity;
            this._cache_json = result;
            Iterator keys = loadval.keys();
            block2: while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.equals("module")) {
                    JSONObject module = loadval.getJSONObject("module");
                    if (!this._wpRec.getLogicalName().equals(module.getString("logicalName"))) {
                        this._wpRec.setLogicalName(module.getString("logicalName"));
                        reindex = true;
                    }
                    this._wpRec.setBeacon(module.getInt("beacon"));
                    continue;
                }
                if (key.equals("services")) continue;
                JSONObject func = loadval.getJSONObject(key);
                String name = func.has("logicalName") ? func.getString("logicalName") : this._wpRec.getLogicalName();
                if (func.has("advertisedValue")) {
                    String pubval = func.getString("advertisedValue");
                    YAPI.setFunctionValue(this._wpRec.getSerialNumber(), pubval);
                }
                for (int f = 0; f < this._functions_funcid.size(); ++f) {
                    if (!this._functions_funcid.get(f).equals(key)) continue;
                    if (this._functions_name.get(f).equals(name)) continue block2;
                    this._functions_name.put(f, name);
                    reindex = true;
                    continue block2;
                }
            }
        }
        catch (JSONException e) {
            throw new YAPI_Exception(-8, "Request failed, could not parse API result");
        }
        if (reindex.booleanValue()) {
            YAPI.reindexDevice(this);
        }
        return 0;
    }

    public void dropCache() {
        this._cache_expiration = 0L;
    }

    protected int functionCount() {
        return this._functions_funcid.size();
    }

    protected String functionId(int idx) {
        if (idx < this._functions_funcid.size()) {
            return this._functions_funcid.get(idx);
        }
        return "";
    }

    protected String functionName(int idx) {
        if (idx < this._functions_name.size()) {
            return this._functions_name.get(idx);
        }
        return "";
    }

    protected String functionValue(int idx) {
        if (idx < this._functions_funcid.size()) {
            return YAPI.getFunctionValue(this._wpRec.getSerialNumber() + "." + this._functions_funcid.get(idx));
        }
        return "";
    }

    byte[] requestHTTP(String request, byte[] rest_of_request, boolean async) throws YAPI_Exception {
        String[] words = request.split(" ");
        if (words.length < 2) {
            throw new YAPI_Exception(-2, "Invalid request, not enough words; expected a method name and a URL");
        }
        String relativeUrl = words[1];
        if (relativeUrl.charAt(0) != '/') {
            relativeUrl = "/" + relativeUrl;
        }
        String shortRequest = String.format("%s %s%s\r\n", words[0], this._wpRec.getNetworkUrl(), relativeUrl);
        return this._hub.devRequest(this, shortRequest, rest_of_request, async);
    }
}

