/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataLogger;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YDataStream {
    public static final double DATA_INVALID = -1.79769313486231E308;
    private YDataLogger _dataLogger;
    private int _runNo;
    private int _timeStamp;
    private int _interval;
    private long _utcStamp;
    private int _nRows;
    private int _nCols;
    private ArrayList<String> _columnNames;
    private ArrayList<ArrayList<Double>> _values;

    public YDataStream(YDataLogger parent, JSONArray jsondata) throws YAPI_Exception {
        try {
            this._dataLogger = parent;
            this._runNo = jsondata.getInt(0);
            this._timeStamp = jsondata.getInt(1);
            this._utcStamp = jsondata.getLong(2);
            this._interval = jsondata.getInt(3);
            this._nRows = 0;
            this._nCols = 0;
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
    }

    public int loadStream() throws YAPI_Exception {
        int[] colofs;
        double[] colscl;
        int c;
        int i;
        JSONArray coldiv = null;
        int[] coltyp = null;
        int[] caltyp = null;
        YAPI.CalibrationHandlerCallback[] calhdl = null;
        ArrayList<ArrayList<Integer>> calpar = null;
        ArrayList<ArrayList<Double>> calraw = null;
        ArrayList<ArrayList<Double>> calref = null;
        JSONObject jsonObj = null;
        try {
            JSONTokener jsonTokenner = this._dataLogger.getData(this._runNo, this._timeStamp);
            jsonObj = new JSONObject(jsonTokenner);
            if (jsonObj.has("time")) {
                this._timeStamp = jsonObj.getInt("time");
            }
            if (jsonObj.has("UTC")) {
                this._utcStamp = jsonObj.getLong("UTC");
            }
            if (jsonObj.has("interval")) {
                this._interval = jsonObj.getInt("interval");
            }
            if (jsonObj.has("nRows")) {
                this._nRows = jsonObj.getInt("nRows");
            }
            if (jsonObj.has("keys")) {
                JSONArray jsonKeys = jsonObj.getJSONArray("keys");
                if (this._nCols == 0) {
                    this._nCols = jsonKeys.length();
                } else if (this._nCols != jsonKeys.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
                this._columnNames = new ArrayList(this._runNo);
                for (i = 0; i < jsonKeys.length(); ++i) {
                    this._columnNames.add(jsonKeys.getString(i));
                }
            }
            if (jsonObj.has("div")) {
                coldiv = jsonObj.getJSONArray("div");
                if (this._nCols == 0) {
                    this._nCols = coldiv.length();
                } else if (this._nCols != coldiv.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
            }
            if (jsonObj.has("type")) {
                JSONArray types = jsonObj.getJSONArray("type");
                if (this._nCols == 0) {
                    this._nCols = types.length();
                } else if (this._nCols != types.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
                coltyp = new int[this._nCols];
                for (c = 0; c < this._nCols; ++c) {
                    coltyp[c] = types.getInt(c);
                }
            }
            if (jsonObj.has("scal")) {
                JSONArray json_colscl = jsonObj.getJSONArray("scal");
                if (this._nCols == 0) {
                    this._nCols = json_colscl.length();
                } else if (this._nCols != json_colscl.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
                colscl = new double[json_colscl.length()];
                colofs = new int[json_colscl.length()];
                for (i = 0; i < json_colscl.length(); ++i) {
                    double dval = json_colscl.getDouble(i);
                    colscl[i] = dval / 65536.0;
                    colofs[i] = coltyp[i] != 0 ? -32767 : 0;
                }
            } else {
                colscl = new double[coldiv.length()];
                colofs = new int[coldiv.length()];
                for (int i2 = 0; i2 < coldiv.length(); ++i2) {
                    colscl[i2] = 1.0 / coldiv.getDouble(i2);
                    colofs[i2] = coltyp[i2] != 0 ? -32767 : 0;
                }
            }
            if (jsonObj.has("cal")) {
                JSONArray jsonCal = jsonObj.getJSONArray("cal");
                calhdl = new YAPI.CalibrationHandlerCallback[jsonCal.length()];
                caltyp = new int[jsonCal.length()];
                calpar = new ArrayList<ArrayList<Integer>>(jsonCal.length());
                calraw = new ArrayList<ArrayList<Double>>(jsonCal.length());
                calref = new ArrayList<ArrayList<Double>>(jsonCal.length());
                for (c = 0; c > jsonCal.length(); ++c) {
                    String calibration_str = jsonCal.getString(c);
                    ArrayList<Integer> cur_calpar = new ArrayList<Integer>();
                    ArrayList<Double> cur_calraw = new ArrayList<Double>();
                    ArrayList<Double> cur_calref = new ArrayList<Double>();
                    int calibType = YAPI._decodeCalibrationPoints(calibration_str, cur_calpar, cur_calraw, cur_calref, colscl[c], colofs[c]);
                    calhdl[c] = YAPI.getCalibrationHandler(calibType);
                    caltyp[c] = calibType;
                    calpar.set(c, cur_calpar);
                    calraw.set(c, cur_calraw);
                    calref.set(c, cur_calref);
                }
            }
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, "json parse error");
        }
        if (jsonObj != null && jsonObj.has("data")) {
            if (this._nCols == 0 || coldiv == null || coltyp == null) {
                throw new YAPI_Exception(-8, "DataStream corrupted");
            }
            ArrayList udata = null;
            try {
                String data = jsonObj.getString("data");
                udata = new ArrayList();
                int datalen = data.length();
                int i3 = 0;
                while (i3 < datalen) {
                    int c2;
                    if ((c2 = data.charAt(i3++)) >= 97) {
                        int srcpos = udata.size() - 1 - (c2 - 97);
                        if (srcpos < 0) {
                            throw new YAPI_Exception(-8, "");
                        }
                        udata.add(udata.get(srcpos));
                        continue;
                    }
                    if (i3 + 2 > datalen) {
                        throw new YAPI_Exception(-8, "");
                    }
                    int val = c2 - 48;
                    c2 = data.charAt(i3++);
                    val += c2 - 48 << 5;
                    if ((c2 = data.charAt(i3++)) == 122) {
                        c2 = 92;
                    }
                    udata.add(val += c2 - 48 << 10);
                }
            }
            catch (JSONException ex) {
                // empty catch block
            }
            if (udata == null) {
                try {
                    JSONArray jsonData = jsonObj.getJSONArray("data");
                    udata = new ArrayList();
                    for (i = 0; i < jsonData.length(); ++i) {
                        udata.add(jsonData.getInt(i));
                    }
                }
                catch (JSONException ex) {
                    throw new YAPI_Exception(-8, "");
                }
            }
            this._values = new ArrayList();
            ArrayList<Double> dat = new ArrayList<Double>();
            c = 0;
            Iterator i$ = udata.iterator();
            while (i$.hasNext()) {
                int val_i = (Integer)i$.next();
                double val_d = coltyp[c] < 2 ? (double)(val_i + colofs[c]) * colscl[c] : YAPI._decimalToDouble(val_i - Short.MAX_VALUE);
                if (calhdl != null && calhdl[c] != null) {
                    YAPI.CalibrationHandlerCallback handler = calhdl[c];
                    double cval = val_d;
                    if (caltyp[c] <= 10) {
                        cval = handler.yCalibrationHandler((double)(val_i + colofs[c]) + colscl[c], caltyp[c], (ArrayList)calpar.get(c), (ArrayList)calraw.get(c), (ArrayList)calref.get(c));
                    } else if (caltyp[c] > 20) {
                        cval = handler.yCalibrationHandler(val_d, caltyp[c], (ArrayList)calpar.get(c), (ArrayList)calraw.get(c), (ArrayList)calref.get(c));
                    }
                    dat.add(cval);
                } else {
                    dat.add(val_d);
                }
                if (++c != this._nCols) continue;
                this._values.add(dat);
                dat = new ArrayList();
                c = 0;
            }
        }
        return 0;
    }

    public int get_runIndex() {
        return this._runNo;
    }

    public int getRunIndex() {
        return this._runNo;
    }

    public int get_startTime() {
        return this._timeStamp;
    }

    public int getStartTime() {
        return this._timeStamp;
    }

    public long get_startTimeUTC() {
        return this._utcStamp;
    }

    public long getStartTimeUTC() {
        return this._utcStamp;
    }

    public int get_dataSamplesInterval() {
        return this._interval;
    }

    public int getDataSamplesInterval() {
        return this._interval;
    }

    public int get_rowCount() throws YAPI_Exception {
        if (this._nRows == 0) {
            this.loadStream();
        }
        return this._nRows;
    }

    public int getRowCount() throws YAPI_Exception {
        return this.get_rowCount();
    }

    public int get_columnCount() throws YAPI_Exception {
        if (this._nCols == 0) {
            this.loadStream();
        }
        return this._nCols;
    }

    public int getColumnCount() throws YAPI_Exception {
        return this.get_columnCount();
    }

    public String[] get_columnNames() throws YAPI_Exception {
        if (this._columnNames.isEmpty()) {
            this.loadStream();
        }
        return this._columnNames.toArray(new String[0]);
    }

    public String[] getColumnNames() throws YAPI_Exception {
        return this.get_columnNames();
    }

    public ArrayList<ArrayList<Double>> get_dataRows() throws YAPI_Exception {
        if (this._values.isEmpty()) {
            this.loadStream();
        }
        return this._values;
    }

    public ArrayList<ArrayList<Double>> getDataRows() throws YAPI_Exception {
        return this.get_dataRows();
    }

    public double get_data(int row, int col) throws YAPI_Exception {
        if (this._values.isEmpty()) {
            this.loadStream();
        }
        if (row >= this._values.size()) {
            return -1.79769313486231E308;
        }
        if (col >= this._nCols) {
            return -1.79769313486231E308;
        }
        return this._values.get(row).get(col);
    }

    public double getData(int row, int col) throws YAPI_Exception {
        return this.get_data(row, col);
    }
}

