/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataLogger;
import com.yoctopuce.YoctoAPI.YDataStream;
import java.util.ArrayList;
import java.util.HashMap;

public class YDataRun {
    public static final double MINVALUE_INVALID = -1.79769313486231E308;
    public static final double AVERAGEVALUE_INVALID = -1.79769313486231E308;
    public static final double MAXVALUE_INVALID = -1.79769313486231E308;
    private YDataLogger _dataLogger;
    private int _runNo;
    private ArrayList<YDataStream> _streams;
    private ArrayList<String> _measureNames;
    private int _browseInterval;
    private long _startTimeUTC;
    private long _duration;
    private boolean _isLive;
    private HashMap<String, ArrayList<Double>> _minValues;
    private HashMap<String, ArrayList<Double>> _avgValues;
    private HashMap<String, ArrayList<Double>> _maxValues;

    YDataRun(YDataLogger parent, int run) {
        this._dataLogger = parent;
        this._runNo = run;
        this._streams = new ArrayList();
        this._browseInterval = 60;
        this._startTimeUTC = 0L;
        this._duration = 0L;
        this._isLive = false;
    }

    void addStream(YDataStream stream) {
        this._streams.add(stream);
        if (this._startTimeUTC == 0L && stream.get_startTimeUTC() > 0L) {
            this._startTimeUTC = stream.getStartTimeUTC() - (long)stream.getStartTime();
        }
    }

    void yfinalize() throws YAPI_Exception {
        YDataStream last = this._streams.get(this._streams.size() - 1);
        this._duration = last.getStartTime() + last.getRowCount() * last.getDataSamplesInterval();
        boolean bl = this._isLive = this._dataLogger.getCurrentRunIndex() == this._runNo && this._dataLogger.getRecording() == 1;
        if (this._isLive && this._startTimeUTC == 0L) {
            this._startTimeUTC = System.currentTimeMillis() / 1000L - this._duration;
        }
        this._measureNames = this._dataLogger.getMeasureNames();
        if (this._streams.size() > 0) {
            this.setValueInterval(this._streams.get(0).getDataSamplesInterval());
        } else {
            this.setValueInterval(60);
        }
    }

    private void refresh() throws YAPI_Exception {
        if (this._isLive) {
            YDataStream last = this._streams.get(this._streams.size() - 1);
            last.loadStream();
            this._duration = last.getStartTime() + last.getRowCount() * last.getDataSamplesInterval();
            if (System.currentTimeMillis() / 1000L > this._startTimeUTC + this._duration) {
                boolean newStreams = false;
                ArrayList<YDataStream> streams = new ArrayList<YDataStream>();
                this._dataLogger.get_dataStreams(streams);
                for (YDataStream stream : streams) {
                    if (stream.get_runIndex() != this._runNo || stream.get_startTime() <= last.get_startTime()) continue;
                    this.addStream(stream);
                    newStreams = true;
                }
                if (newStreams) {
                    this.yfinalize();
                }
            }
            this._isLive = this._dataLogger.get_recording() == 1;
        }
    }

    private void invalidValue(int pos) {
        for (String key : this._measureNames) {
            this._minValues.get(key).set(pos, -1.79769313486231E308);
            this._avgValues.get(key).set(pos, -1.79769313486231E308);
            this._maxValues.get(key).set(pos, -1.79769313486231E308);
        }
    }

    private void computeValues(int pos) throws YAPI_Exception {
        int startTime;
        int row;
        int nextAvail;
        int prevMissing;
        if (this._streams.isEmpty()) {
            this.invalidValue(pos);
            return;
        }
        long time = pos * this._browseInterval;
        int si = this._streams.size() - 1;
        YDataStream stream = this._streams.get(si);
        while ((long)stream.get_startTime() > time && si > 0) {
            stream = this._streams.get(--si);
        }
        int streamInterval = stream.get_dataSamplesInterval();
        int thisAvail = stream.get_startTime() / this._browseInterval;
        int nextMissing = (stream.get_startTime() + stream.get_rowCount() * streamInterval + streamInterval - 1) / this._browseInterval;
        if ((long)(nextMissing * this._browseInterval) <= time && si < this._streams.size() - 1) {
            prevMissing = nextMissing;
            stream = this._streams.get(++si);
            streamInterval = stream.get_dataSamplesInterval();
            thisAvail = stream.get_startTime() / this._browseInterval;
            nextMissing = (stream.get_startTime() + stream.get_rowCount() * streamInterval + streamInterval - 1) / this._browseInterval;
        } else {
            prevMissing = thisAvail - 1;
        }
        if (si + 1 >= this._streams.size()) {
            nextAvail = pos + 1;
        } else {
            YDataStream nextStream = this._streams.get(si + 1);
            nextAvail = nextStream.get_startTime() / this._browseInterval;
        }
        if (pos >= prevMissing && pos < thisAvail) {
            for (pos = prevMissing; pos < thisAvail; ++pos) {
                this.invalidValue(pos);
            }
            return;
        }
        if (pos >= nextMissing && pos < nextAvail) {
            for (pos = nextMissing; pos < nextAvail; ++pos) {
                this.invalidValue(pos);
            }
            return;
        }
        if (prevMissing < thisAvail) {
            row = 0;
            pos = thisAvail;
            startTime = stream.get_startTime();
        } else {
            pos = (stream.get_startTime() + this._browseInterval - 1) / this._browseInterval;
            row = (pos * this._browseInterval - stream.get_startTime() + streamInterval / 2) / streamInterval;
            startTime = stream.get_startTime() + row * streamInterval;
        }
        boolean stopAsap = false;
        HashMap<String, Integer> minCol = new HashMap<String, Integer>();
        HashMap<String, Integer> avgCol = new HashMap<String, Integer>();
        HashMap<String, Integer> maxCol = new HashMap<String, Integer>();
        HashMap<String, Double> minVal = new HashMap<String, Double>();
        HashMap<String, Double> avgVal = new HashMap<String, Double>();
        HashMap<String, Double> maxVal = new HashMap<String, Double>();
        int divisor = 0;
        int boundary = (pos + 1) * this._browseInterval;
        int stopTime = (stream.get_startTime() + stream.get_rowCount() * stream.get_dataSamplesInterval()) / this._browseInterval * this._browseInterval;
        while (startTime < stopTime) {
            int nextTime = startTime + streamInterval;
            if (avgCol.isEmpty()) {
                String[] streamsCols = stream.get_columnNames();
                for (int idx = 0; idx < streamsCols.length; ++idx) {
                    String colname = streamsCols[idx];
                    if (colname.charAt(colname.length() - 4) == '_') {
                        String name = colname.substring(0, colname.length() - 4);
                        String suffix = colname.substring(colname.length() - 3);
                        if (suffix.equals("min")) {
                            minCol.put(name, idx);
                            continue;
                        }
                        if (suffix.equals("avg")) {
                            avgCol.put(name, idx);
                            continue;
                        }
                        if (!suffix.equals("max")) continue;
                        maxCol.put(name, idx);
                        continue;
                    }
                    minCol.put(colname, idx);
                    avgCol.put(colname, idx);
                    maxCol.put(colname, idx);
                }
            }
            if (divisor == 0) {
                if (boundary <= nextTime) {
                    while (boundary <= nextTime) {
                        for (String key : this._measureNames) {
                            this._minValues.get(key).set(pos, stream.get_data(row, (Integer)minCol.get(key)));
                            this._avgValues.get(key).set(pos, stream.get_data(row, (Integer)avgCol.get(key)));
                            this._maxValues.get(key).set(pos, stream.get_data(row, (Integer)maxCol.get(key)));
                        }
                        boundary = (++pos + 1) * this._browseInterval;
                    }
                } else {
                    divisor = streamInterval;
                    for (String key : this._measureNames) {
                        minVal.put(key, stream.get_data(row, (Integer)minCol.get(key)));
                        avgVal.put(key, stream.get_data(row, (Integer)avgCol.get(key)) * (double)streamInterval);
                        maxVal.put(key, stream.get_data(row, (Integer)maxCol.get(key)));
                    }
                }
            } else {
                divisor += streamInterval;
                for (String key : this._measureNames) {
                    minVal.put(key, Math.min((Double)minVal.get(key), stream.getData(row, (Integer)minCol.get(key))));
                    double val = (Double)avgVal.get(key) + (double)streamInterval * stream.getData(row, (Integer)avgCol.get(key));
                    avgVal.put(key, val);
                    maxVal.put(key, Math.max((Double)maxVal.get(key), stream.getData(row, (Integer)maxCol.get(key))));
                }
                if (2 * Math.abs(nextTime - boundary) <= streamInterval) {
                    for (String key : this._measureNames) {
                        this._minValues.get(key).set(pos, (Double)minVal.get(key));
                        this._avgValues.get(key).set(pos, (Double)avgVal.get(key) / (double)divisor);
                        this._maxValues.get(key).set(pos, (Double)maxVal.get(key));
                    }
                    divisor = 0;
                    boundary = (++pos + 1) * this._browseInterval;
                    if (stopAsap) break;
                }
            }
            if (++row < stream.get_rowCount()) {
                startTime = nextTime;
                continue;
            }
            if (++si >= this._streams.size()) break;
            stream = this._streams.get(si);
            startTime = stream.get_startTime();
            streamInterval = stream.get_dataSamplesInterval();
            row = 0;
            avgCol = new HashMap();
            stopAsap = true;
        }
        if (divisor > 0) {
            for (String key : this._measureNames) {
                this._minValues.get(key).set(pos, (Double)minVal.get(key));
                this._avgValues.get(key).set(pos, (Double)avgVal.get(key) / (double)divisor);
                this._maxValues.get(key).set(pos, (Double)maxVal.get(key));
            }
        }
    }

    public String[] get_measureNames() {
        return this._measureNames.toArray(new String[0]);
    }

    public String[] getMeasureNames() {
        return this.get_measureNames();
    }

    public long get_startTimeUTC() {
        return this._startTimeUTC;
    }

    public long getStartTimeUTC() {
        return this._startTimeUTC;
    }

    public long get_duration() throws YAPI_Exception {
        if (this._isLive) {
            this.refresh();
        }
        return this._duration;
    }

    public long getDuration() throws YAPI_Exception {
        return this.get_duration();
    }

    public int get_valueInterval() {
        return this._browseInterval;
    }

    public int getValueInterval() {
        return this.get_valueInterval();
    }

    public void set_valueInterval(int valueInterval) throws YAPI_Exception {
        YDataStream last = this._streams.get(this._streams.size() - 1);
        String[] names = last.getColumnNames();
        this._minValues = new HashMap();
        this._avgValues = new HashMap();
        this._maxValues = new HashMap();
        for (String name : names) {
            if (name.charAt(name.length() - 4) == '_') {
                name = name.substring(0, name.length() - 4);
            }
            if (this._minValues.containsKey(name)) continue;
            this._minValues.put(name, new ArrayList());
            this._avgValues.put(name, new ArrayList());
            this._maxValues.put(name, new ArrayList());
        }
        this._browseInterval = valueInterval;
    }

    public void setValueInterval(int valueInterval) throws YAPI_Exception {
        this.set_valueInterval(valueInterval);
    }

    public int get_valueCount() throws YAPI_Exception {
        if (this._isLive) {
            this.refresh();
        }
        return (int)(this._duration / (long)this._browseInterval);
    }

    public int getValueCount() throws YAPI_Exception {
        return this.get_valueCount();
    }

    public double get_minValue(String measureName, int pos) throws YAPI_Exception {
        if (!this._minValues.containsKey(measureName) || this._minValues.get(measureName).size() <= pos) {
            this.computeValues(pos);
        }
        return this._minValues.get(measureName).get(pos);
    }

    public double getMinValue(String measureName, int pos) throws YAPI_Exception {
        return this.get_minValue(measureName, pos);
    }

    public double get_averageValue(String measureName, int pos) throws YAPI_Exception {
        if (!this._avgValues.containsKey(measureName) || this._avgValues.get(measureName).size() <= pos) {
            this.computeValues(pos);
        }
        return this._avgValues.get(measureName).get(pos);
    }

    public double getAverageValue(String measureName, int pos) throws YAPI_Exception {
        return this.get_averageValue(measureName, pos);
    }

    public double get_maxValue(String measureName, int pos) throws YAPI_Exception {
        if (!this._maxValues.containsKey(measureName) || this._maxValues.get(measureName).size() <= pos) {
            this.computeValues(pos);
        }
        return this._maxValues.get(measureName).get(pos);
    }

    public double getMaxValue(String measureName, int pos) throws YAPI_Exception {
        return this.get_maxValue(measureName, pos);
    }
}

