/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataRun;
import com.yoctopuce.YoctoAPI.YDataStream;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFunction;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YDataLogger
extends YFunction {
    protected String _dataLoggerURL;
    protected ArrayList<String> _measureNames;
    protected HashMap<Integer, YDataRun> _dataRuns;
    protected long _liveRun;
    private YFunction.UpdateCallback _valueCallbackDataLogger;
    public static final String LOGICALNAME_INVALID = "!INVALID!";
    public static final String ADVERTISEDVALUE_INVALID = "!INVALID!";
    public static final int OLDESTRUNINDEX_INVALID = -1;
    public static final int CURRENTRUNINDEX_INVALID = -1;
    public static final int SAMPLINGINTERVAL_INVALID = -1;
    public static final long TIMEUTC_INVALID = -9223372036854775807L;
    public static final int RECORDING_OFF = 0;
    public static final int RECORDING_ON = 1;
    public static final int RECORDING_INVALID = -1;
    public static final int AUTOSTART_OFF = 0;
    public static final int AUTOSTART_ON = 1;
    public static final int AUTOSTART_INVALID = -1;
    public static final int CLEARHISTORY_FALSE = 0;
    public static final int CLEARHISTORY_TRUE = 1;
    public static final int CLEARHISTORY_INVALID = -1;

    public JSONTokener getData(Integer runIdx, Integer timeIdx) throws YAPI_Exception {
        String result;
        if (this._dataLoggerURL == null) {
            this._dataLoggerURL = "/logger.json";
        }
        String devid = this.module().get_serialNumber();
        String httpreq = "GET " + this._dataLoggerURL;
        if (timeIdx != null) {
            httpreq = httpreq + String.format("?run=%d&time=%d", runIdx, timeIdx);
        }
        YDevice dev = YAPI.getDevice(devid);
        try {
            result = new String(dev.requestHTTP(httpreq, null, false));
        }
        catch (YAPI_Exception ex) {
            if (!this._dataLoggerURL.equals("/dataLogger.json")) {
                this._dataLoggerURL = "/dataLogger.json";
                return this.getData(runIdx, timeIdx);
            }
            throw ex;
        }
        JSONTokener loadval = new JSONTokener(result);
        return loadval;
    }

    public int loadRuns() throws YAPI_Exception {
        String[] names;
        this._measureNames = new ArrayList();
        this._dataRuns = new HashMap();
        this._liveRun = this.get_currentRunIndex();
        ArrayList<YDataStream> streams = new ArrayList<YDataStream>();
        this.get_dataStreams(streams);
        for (YDataStream stream : streams) {
            int runIdx = stream.get_runIndex();
            if (!this._dataRuns.containsKey(runIdx)) {
                YDataRun drun = new YDataRun(this, runIdx);
                this._dataRuns.put(runIdx, drun);
            }
            this._dataRuns.get(runIdx).addStream(stream);
        }
        YDataStream stream = streams.get(0);
        for (String name : names = stream.get_columnNames()) {
            if (name.charAt(name.length() - 4) != '_') {
                this._measureNames.add(name);
                continue;
            }
            if (!name.substring(name.length() - 4).equals("_min")) continue;
            this._measureNames.add(name.substring(name.length() - 4));
        }
        for (YDataRun run : this._dataRuns.values()) {
            run.yfinalize();
        }
        return 0;
    }

    public int forgetAllDataStreams() throws YAPI_Exception {
        return this.set_clearHistory(1);
    }

    public ArrayList<String> get_measureNames() {
        return this._measureNames;
    }

    public ArrayList<String> getMeasureNames() {
        return this._measureNames;
    }

    public YDataRun get_dataRun(int runIdx) throws YAPI_Exception {
        if (this._dataRuns == null || (long)runIdx > this._liveRun) {
            this.loadRuns();
        }
        if (!this._dataRuns.containsKey(runIdx)) {
            return null;
        }
        return this._dataRuns.get(runIdx);
    }

    public YDataRun getDataRun(int runIdx) throws YAPI_Exception {
        return this.get_dataRun(runIdx);
    }

    public int get_dataStreams(ArrayList<YDataStream> v) throws YAPI_Exception {
        JSONTokener loadval = this.getData(null, null);
        try {
            JSONArray jsonAllStreams = new JSONArray(loadval);
            for (int i = 0; i < jsonAllStreams.length(); ++i) {
                JSONArray jsonStream = jsonAllStreams.getJSONArray(i);
                YDataStream stream = new YDataStream(this, jsonStream);
                v.add(stream);
            }
        }
        catch (JSONException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        return 0;
    }

    public int getDataStreams(ArrayList<YDataStream> v) throws YAPI_Exception {
        return this.get_dataStreams(v);
    }

    public String get_logicalName() throws YAPI_Exception {
        String json_val = (String)this._getAttr("logicalName");
        return json_val;
    }

    public String getLogicalName() throws YAPI_Exception {
        return this.get_logicalName();
    }

    public int set_logicalName(String newval) throws YAPI_Exception {
        String rest_val = newval;
        this._setAttr("logicalName", rest_val);
        return 0;
    }

    public int setLogicalName(String newval) throws YAPI_Exception {
        return this.set_logicalName(newval);
    }

    @Override
    public String get_advertisedValue() throws YAPI_Exception {
        String json_val = (String)this._getAttr("advertisedValue");
        return json_val;
    }

    public String getAdvertisedValue() throws YAPI_Exception {
        return this.get_advertisedValue();
    }

    public int get_oldestRunIndex() throws YAPI_Exception {
        String json_val = (String)this._getAttr("oldestRunIndex");
        return Integer.parseInt(json_val);
    }

    public int getOldestRunIndex() throws YAPI_Exception {
        return this.get_oldestRunIndex();
    }

    public int get_currentRunIndex() throws YAPI_Exception {
        String json_val = (String)this._getAttr("currentRunIndex");
        return Integer.parseInt(json_val);
    }

    public int getCurrentRunIndex() throws YAPI_Exception {
        return this.get_currentRunIndex();
    }

    public int get_samplingInterval() throws YAPI_Exception {
        String json_val = (String)this._getAttr("samplingInterval");
        return Integer.parseInt(json_val);
    }

    public int getSamplingInterval() throws YAPI_Exception {
        return this.get_samplingInterval();
    }

    public int set_samplingInterval(int newval) throws YAPI_Exception {
        String rest_val = Long.toString(newval);
        this._setAttr("samplingInterval", rest_val);
        return 0;
    }

    public int setSamplingInterval(int newval) throws YAPI_Exception {
        return this.set_samplingInterval(newval);
    }

    public long get_timeUTC() throws YAPI_Exception {
        String json_val = (String)this._getAttr("timeUTC");
        return Long.parseLong(json_val);
    }

    public long getTimeUTC() throws YAPI_Exception {
        return this.get_timeUTC();
    }

    public int set_timeUTC(long newval) throws YAPI_Exception {
        String rest_val = Long.toString(newval);
        this._setAttr("timeUTC", rest_val);
        return 0;
    }

    public int setTimeUTC(long newval) throws YAPI_Exception {
        return this.set_timeUTC(newval);
    }

    public int get_recording() throws YAPI_Exception {
        String json_val = (String)this._getAttr("recording");
        return Integer.parseInt(json_val);
    }

    public int getRecording() throws YAPI_Exception {
        return this.get_recording();
    }

    public int set_recording(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("recording", rest_val);
        return 0;
    }

    public int setRecording(int newval) throws YAPI_Exception {
        return this.set_recording(newval);
    }

    public int get_autoStart() throws YAPI_Exception {
        String json_val = (String)this._getAttr("autoStart");
        return Integer.parseInt(json_val);
    }

    public int getAutoStart() throws YAPI_Exception {
        return this.get_autoStart();
    }

    public int set_autoStart(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("autoStart", rest_val);
        return 0;
    }

    public int setAutoStart(int newval) throws YAPI_Exception {
        return this.set_autoStart(newval);
    }

    public int get_clearHistory() throws YAPI_Exception {
        String json_val = (String)this._getAttr("clearHistory");
        return Integer.parseInt(json_val);
    }

    public int getClearHistory() throws YAPI_Exception {
        return this.get_clearHistory();
    }

    public int set_clearHistory(int newval) throws YAPI_Exception {
        String rest_val = newval > 0 ? "1" : "0";
        this._setAttr("clearHistory", rest_val);
        return 0;
    }

    public int setClearHistory(int newval) throws YAPI_Exception {
        return this.set_clearHistory(newval);
    }

    public YDataLogger nextDataLogger() {
        String next_hwid = YAPI.getNextHardwareId(this._className, this._func);
        if (next_hwid == null) {
            return null;
        }
        return YDataLogger.FindDataLogger(next_hwid);
    }

    public static YDataLogger FindDataLogger(String func) {
        YFunction yfunc = YAPI.getFunction("DataLogger", func);
        if (yfunc != null) {
            return (YDataLogger)yfunc;
        }
        return new YDataLogger(func);
    }

    public static YDataLogger FirstDataLogger() {
        String next_hwid = YAPI.getFirstHardwareId("DataLogger");
        if (next_hwid == null) {
            return null;
        }
        return YDataLogger.FindDataLogger(next_hwid);
    }

    private YDataLogger(String func) {
        super("DataLogger", func);
    }

    @Override
    void advertiseValue(String newvalue) {
        super.advertiseValue(newvalue);
        if (this._valueCallbackDataLogger != null) {
            this._valueCallbackDataLogger.yNewValue(this, newvalue);
        }
    }

    @Override
    protected boolean hasCallbackRegistered() {
        return super.hasCallbackRegistered() || this._valueCallbackDataLogger != null;
    }

    @Override
    public void registerValueCallback(YFunction.UpdateCallback callback) {
        this._valueCallbackDataLogger = callback;
        if (callback != null && this.isOnline()) {
            try {
                String newval = this.get_advertisedValue();
                if (!newval.equals("") && !newval.equals("!INVALDI!")) {
                    callback.yNewValue(this, newval);
                }
            }
            catch (YAPI_Exception yAPI_Exception) {
                // empty catch block
            }
        }
    }
}

