/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YFunctionType;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import com.yoctopuce.YoctoAPI.YModule;
import com.yoctopuce.YoctoAPI.YUSBHub;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YAPI {
    private static Boolean _apiInitialized = false;
    public static int DefaultCacheValidity = 5;
    public static final String INVALID_STRING = "!INVALID!";
    public static final double INVALID_DOUBLE = -1.79769313486231E308;
    public static final int INVALID_INT = Integer.MIN_VALUE;
    public static final long INVALID_LONG = -9223372036854775807L;
    public static final int INVALID_UNSIGNED = -1;
    public static final String YOCTO_API_VERSION_STR = "1.01";
    public static final int YOCTO_API_VERSION_BCD = 257;
    public static final int YOCTO_VENDORID = 9440;
    public static final int YOCTO_DEVID_FACTORYBOOT = 1;
    public static final int YOCTO_DEVID_BOOTLOADER = 2;
    public static final int SUCCESS = 0;
    public static final int NOT_INITIALIZED = -1;
    public static final int INVALID_ARGUMENT = -2;
    public static final int NOT_SUPPORTED = -3;
    public static final int DEVICE_NOT_FOUND = -4;
    public static final int VERSION_MISMATCH = -5;
    public static final int DEVICE_BUSY = -6;
    public static final int TIMEOUT = -7;
    public static final int IO_ERROR = -8;
    public static final int NO_MORE_DATA = -9;
    public static final int EXHAUSTED = -10;
    public static final int DOUBLE_ACCES = -11;
    public static final int UNAUTHORIZED = -12;
    static final String DefaultEncoding = "ISO-8859-1";
    static final int YOCTO_MANUFACTURER_LEN = 20;
    static final int YOCTO_SERIAL_LEN = 20;
    static final int YOCTO_BASE_SERIAL_LEN = 8;
    static final int YOCTO_PRODUCTNAME_LEN = 28;
    static final int YOCTO_FIRMWARE_LEN = 22;
    static final int YOCTO_LOGICAL_LEN = 20;
    static final int YOCTO_FUNCTION_LEN = 20;
    static final int YOCTO_PUBVAL_SIZE = 6;
    static final int YOCTO_PUBVAL_LEN = 16;
    static final int YOCTO_PASS_LEN = 20;
    static final int YOCTO_REALM_LEN = 20;
    public static final int DETECT_NONE = 0;
    public static final int DETECT_USB = 1;
    public static final int DETECT_NET = 2;
    public static final int DETECT_ALL = 3;
    private static ArrayList<YGenericHub> _hubs = new ArrayList();
    private static HashMap<String, YDevice> _devs = new HashMap();
    private static HashMap<String, String> _snByUrl = new HashMap();
    private static HashMap<String, String> _snByName = new HashMap();
    private static HashMap<String, YFunctionType> _fnByType = new HashMap();
    private static boolean _firstArrival = true;
    private static final Queue<PlugEvent> _pendingCallbacks = new LinkedList<PlugEvent>();
    private static final Queue<PendingValue> _pendingValues = new LinkedList<PendingValue>();
    private static DeviceArrivalCallback _arrivalCallback = null;
    private static DeviceChangeCallback _namechgCallback = null;
    private static DeviceRemovalCallback _removalCallback = null;
    private static LogCallback _logCallback = null;
    private static HashMap<Integer, CalibrationHandlerCallback> _calibHandlers = new HashMap();
    private static CalibrationHandlerCallback linearCalibrationHandler = new CalibrationHandlerCallback(){

        @Override
        public double yCalibrationHandler(double rawValue, int calibType, ArrayList<Integer> params, ArrayList<Double> rawValues, ArrayList<Double> refValues) {
            int npt = calibType % 10;
            double x = rawValues.get(0);
            double adj = refValues.get(0) - x;
            int i = 0;
            if (npt > rawValues.size()) {
                npt = rawValues.size();
            }
            if (npt > refValues.size()) {
                npt = refValues.size();
            }
            while (rawValue > rawValues.get(i) && ++i < npt) {
                double x2 = x;
                double adj2 = adj;
                x = rawValues.get(i);
                adj = refValues.get(i) - x;
                if (!(rawValue < x) || !(x > x2)) continue;
                adj = adj2 + (adj - adj2) * (rawValue - x2) / (x - x2);
            }
            return rawValue + adj;
        }
    };
    static double[] decExp = new double[]{1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pushPlugEvent(PlugEvent.Event ev, String serial) {
        Queue<PlugEvent> queue = _pendingCallbacks;
        synchronized (queue) {
            _pendingCallbacks.add(new PlugEvent(ev, serial));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _updateDeviceList_internal(boolean forceupdate, boolean invokecallbacks) throws YAPI_Exception {
        if (_firstArrival && invokecallbacks && _arrivalCallback != null) {
            forceupdate = true;
        }
        for (YGenericHub h : _hubs) {
            h.updateDeviceList(forceupdate);
        }
        if (invokecallbacks) {
            while (true) {
                PlugEvent evt;
                Queue<PlugEvent> queue = _pendingCallbacks;
                synchronized (queue) {
                    if (_pendingCallbacks.isEmpty()) {
                        break;
                    }
                    evt = _pendingCallbacks.poll();
                }
                switch (evt.ev) {
                    case PLUG: {
                        if (_arrivalCallback == null) break;
                        _arrivalCallback.yDeviceArrival(evt.module);
                        break;
                    }
                    case CHANGE: {
                        if (_namechgCallback == null) break;
                        _namechgCallback.yDeviceChange(evt.module);
                        break;
                    }
                    case UNPLUG: {
                        if (_removalCallback != null) {
                            _removalCallback.yDeviceRemoval(evt.module);
                        }
                        YAPI.forgetDevice(_devs.get(evt.module.get_serialNumber()));
                    }
                }
            }
            if (_arrivalCallback != null && _firstArrival) {
                _firstArrival = false;
            }
        }
    }

    public static CalibrationHandlerCallback getCalibrationHandler(int calibType) {
        if (!_calibHandlers.containsKey(calibType)) {
            return null;
        }
        return _calibHandlers.get(calibType);
    }

    static double _decimalToDouble(int val) {
        boolean negate = false;
        if (val == 0) {
            return 0.0;
        }
        if (val > Short.MAX_VALUE) {
            negate = true;
            val = 65536 - val;
        } else if (val < 0) {
            negate = true;
            val = -val;
        }
        int exp = val >> 11;
        double res = (double)(val & 0x7FF) * decExp[exp];
        return negate ? -res : res;
    }

    static long _doubleToDecimal(double val) {
        int decpow;
        boolean negate = false;
        if (val == 0.0) {
            return 0L;
        }
        if (val < 0.0) {
            negate = true;
            val = -val;
        }
        double comp = val / 1999.0;
        for (decpow = 0; comp > decExp[decpow] && decpow < 15; ++decpow) {
        }
        double mant = val / decExp[decpow];
        long res = decpow == 15 && mant > 2047.0 ? 32767L : (long)(decpow << 11) + Math.round(mant);
        return negate ? -res : res;
    }

    static String _encodeCalibrationPoints(ArrayList<Double> rawValues, ArrayList<Double> refValues, double resolution, int calibrationOffset, String actualCparams) {
        int i;
        int pos;
        int calibType;
        int npt = rawValues.size() < refValues.size() ? rawValues.size() : refValues.size();
        int minRaw = 0;
        if (npt == 0) {
            return "";
        }
        calibType = actualCparams.equals("") ? 10 + npt : ((calibType = Integer.parseInt(actualCparams.substring(0, pos = actualCparams.indexOf(44)))) <= 10 ? npt : 10 + npt);
        String res = Integer.toString(calibType);
        if (calibType <= 10) {
            for (i = 0; i < npt; ++i) {
                int refVal;
                int rawVal = (int)(rawValues.get(i) / resolution - (double)calibrationOffset + 0.5);
                if (rawVal < minRaw || rawVal >= 65536 || (refVal = (int)(refValues.get(i) / resolution - (double)calibrationOffset + 0.5)) < 0 || refVal >= 65536) continue;
                res = res + String.format(",%d,%d", rawVal, refVal);
                minRaw = rawVal + 1;
            }
        } else {
            for (i = 0; i < npt; ++i) {
                int rawVal = (int)YAPI._doubleToDecimal(rawValues.get(i));
                int refVal = (int)YAPI._doubleToDecimal(refValues.get(i));
                res = res + String.format(",%d,%d", rawVal, refVal);
            }
        }
        return res;
    }

    static int _decodeCalibrationPoints(String calibParams, ArrayList<Integer> intPt, ArrayList<Double> rawPt, ArrayList<Double> calPt, double resolution, int calibrationOffset) {
        String[] valuesStr = calibParams.split(",", 0);
        if (intPt != null) {
            intPt.clear();
        }
        rawPt.clear();
        calPt.clear();
        if (valuesStr[0].equals("")) {
            return 0;
        }
        int calibType = 0;
        try {
            calibType = Integer.parseInt(valuesStr[0]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
        int nval = calibType <= 20 ? 2 * (calibType % 10) : 99;
        for (int i = 1; i < nval && i < valuesStr.length; i += 2) {
            double calval_d;
            double rawval_d;
            int rawval = Integer.parseInt(valuesStr[i]);
            int calval = Integer.parseInt(valuesStr[i + 1]);
            if (calibType <= 10) {
                rawval_d = (double)(rawval + calibrationOffset) * resolution;
                calval_d = (double)(calval + calibrationOffset) * resolution;
            } else {
                rawval_d = YAPI._decimalToDouble(rawval);
                calval_d = YAPI._decimalToDouble(calval);
            }
            if (intPt != null) {
                intPt.add(rawval);
                intPt.add(calval);
            }
            rawPt.add(rawval_d);
            calPt.add(calval_d);
        }
        return calibType;
    }

    static double applyCalibration(double rawValue, String calibParams, int calibOffset, double resolution) {
        if (rawValue == -1.79769313486231E308 || resolution == -1.79769313486231E308) {
            return -1.79769313486231E308;
        }
        if (calibParams == null || calibParams.indexOf(44) < 0) {
            return rawValue;
        }
        ArrayList<Integer> cur_calpar = new ArrayList<Integer>();
        ArrayList<Double> cur_calraw = new ArrayList<Double>();
        ArrayList<Double> cur_calref = new ArrayList<Double>();
        int calibType = YAPI._decodeCalibrationPoints(calibParams, cur_calpar, cur_calraw, cur_calref, resolution, calibOffset);
        if (calibType == 0) {
            return rawValue;
        }
        if (!_calibHandlers.containsKey(calibType)) {
            return -1.79769313486231E308;
        }
        return _calibHandlers.get(calibType).yCalibrationHandler(rawValue, calibType, cur_calpar, cur_calraw, cur_calref);
    }

    static int _find_in_bytes(byte[] source, byte[] match) {
        if (source == null || match == null) {
            return -1;
        }
        if (source.length == 0 || match.length == 0) {
            return -1;
        }
        int ret = -1;
        int mpos = 0;
        byte m = match[mpos];
        for (int spos = 0; spos < source.length; ++spos) {
            if (m == source[spos]) {
                if (mpos == 0) {
                    ret = spos;
                } else if (mpos == match.length - 1) {
                    return ret;
                }
                m = match[++mpos];
                continue;
            }
            ret = -1;
            mpos = 0;
            m = match[mpos];
        }
        return ret;
    }

    static YDevice getDevice(String device) {
        YDevice dev = null;
        if (device.startsWith("http://")) {
            String serial;
            if (_snByUrl.containsKey(device) && _devs.containsKey(serial = _snByUrl.get(device))) {
                dev = _devs.get(serial);
            }
        } else if (_devs.containsKey(device)) {
            dev = _devs.get(device);
        } else if (_snByName.containsKey(device)) {
            String serial = _snByName.get(device);
            dev = _devs.get(serial);
        }
        return dev;
    }

    static String functionClass(String funcid) {
        int dotpos = funcid.indexOf(46);
        if (dotpos >= 0) {
            funcid = funcid.substring(dotpos + 1);
        }
        int classlen = funcid.length();
        while (funcid.charAt(classlen - 1) <= '9') {
            --classlen;
        }
        String classname = funcid.substring(0, 1).toUpperCase() + funcid.substring(1, classlen);
        YAPI.getFnByType(classname);
        return classname;
    }

    static void reindexDevice(YDevice dev) {
        String serial = dev.getSerialNumber();
        String lname = dev.getLogicalName();
        _devs.put(serial, dev);
        if (!lname.equals("")) {
            _snByName.put(lname, serial);
        }
        _fnByType.get("Module").reindexFunction(serial + ".module", lname, null);
        int count = dev.functionCount();
        for (int i = 0; i < count; ++i) {
            String funcid = dev.functionId(i);
            String funcname = dev.functionName(i);
            String classname = YAPI.functionClass(funcid);
            _fnByType.get(classname).reindexFunction(serial + "." + funcid, funcname, null);
        }
    }

    static void forgetDevice(YDevice dev) {
        String serial = dev.getSerialNumber();
        String lname = dev.getLogicalName();
        _devs.remove(serial);
        if (_snByName.containsKey(lname) && _snByName.get(lname).equals(serial)) {
            _snByName.remove(lname);
        }
        _fnByType.get("Module").forgetFunction(serial + ".module");
        int count = dev.functionCount();
        for (int i = 0; i < count; ++i) {
            String funcid = dev.functionId(i);
            String classname = YAPI.functionClass(funcid);
            _fnByType.get(classname).forgetFunction(serial + funcid);
        }
    }

    static YFunctionType getFnByType(String className) {
        if (!_fnByType.containsKey(className)) {
            _fnByType.put(className, new YFunctionType(className));
        }
        return _fnByType.get(className);
    }

    static String resolveFunction(String className, String func) throws YAPI_Exception {
        return YAPI.getFnByType(className).resolve(func).toString();
    }

    static void setFunction(String className, String func, YFunction yfunc) {
        YAPI.getFnByType(className).setFunction(func, yfunc);
    }

    static YFunction getFunction(String className, String func) {
        return YAPI.getFnByType(className).getFunction(func);
    }

    static void setFunctionValue(String hwid, String pubval) {
        String classname = YAPI.functionClass(hwid);
        YAPI.getFnByType(classname).setFunctionValue(hwid, pubval);
    }

    static String getFunctionValue(String hwid) {
        String classname = YAPI.functionClass(hwid);
        return YAPI.getFnByType(classname).getFunctionValue(hwid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addValueEvent(YFunction conn_fn, String pubval) {
        Queue<PendingValue> queue = _pendingValues;
        synchronized (queue) {
            _pendingValues.add(new PendingValue(conn_fn, pubval));
        }
    }

    static String getFirstHardwareId(String className) {
        return YAPI.getFnByType(className).getFirstHardwareId();
    }

    static String getNextHardwareId(String className, String hwid) {
        return YAPI.getFnByType(className).getNextHardwareId(hwid);
    }

    private static HashMap<String, String> _json2Hash(JSONObject json) {
        HashMap<String, String> res = new HashMap<String, String>(json.length());
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String value = json.optString(key);
            res.put(key, value);
        }
        return res;
    }

    static YDevice funcGetDevice(String className, String func) throws YAPI_Exception {
        String resolved = null;
        try {
            resolved = YAPI.resolveFunction(className, func);
        }
        catch (YAPI_Exception ex) {
            if (ex.errorType == -4 && _hubs.isEmpty()) {
                throw new YAPI_Exception(ex.errorType, "Impossible to contact any device because no hub has been registered");
            }
            YAPI._updateDeviceList_internal(true, false);
            resolved = YAPI.resolveFunction(className, func);
        }
        func = resolved;
        int dotpos = func.indexOf(46);
        String devid = func.substring(0, dotpos);
        YDevice dev = YAPI.getDevice(devid);
        if (dev == null) {
            YAPI._updateDeviceList_internal(true, false);
            dev = YAPI.getDevice(devid);
            if (dev == null) {
                throw new YAPI_Exception(-4, "Device [" + devid + "] not online");
            }
        }
        return dev;
    }

    static HashMap<String, String> funcRequest(String className, String func, String extra) throws YAPI_Exception {
        YDevice dev = YAPI.funcGetDevice(className, func);
        func = YAPI.resolveFunction(className, func);
        JSONObject loadval = null;
        int dotpos = func.indexOf(46);
        String funcid = func.substring(dotpos + 1);
        if (extra.equals("")) {
            String yreq = dev.requestAPI();
            try {
                JSONObject jsonval = new JSONObject(yreq);
                loadval = jsonval.getJSONObject(funcid);
            }
            catch (JSONException ex) {
                throw new YAPI_Exception(-8, "Request failed, could not parse API result for " + dev);
            }
        } else {
            dev.dropCache();
        }
        if (loadval == null) {
            String httpreq;
            if (extra.equals("")) {
                httpreq = "GET /api/" + funcid + ".json";
                String yreq = new String(dev.requestHTTP(httpreq, null, false));
                try {
                    loadval = new JSONObject(yreq);
                }
                catch (JSONException ex) {
                    throw new YAPI_Exception(-8, "Request failed, could not parse API value for " + httpreq);
                }
            } else {
                httpreq = "GET /api/" + funcid + extra;
                dev.requestHTTP(httpreq, null, true);
                return null;
            }
        }
        return YAPI._json2Hash(loadval);
    }

    private static synchronized void _init_free(boolean mustfree) {
        if (!mustfree) {
            if (!_apiInitialized.booleanValue()) {
                _fnByType.put("Module", new YFunctionType("Module"));
                _apiInitialized = true;
                for (int i = 1; i <= 20; ++i) {
                    _calibHandlers.put(i, linearCalibrationHandler);
                }
            }
        } else if (_apiInitialized.booleanValue()) {
            for (YGenericHub h : _hubs) {
                h.stopNotifications();
                h.release();
            }
            _hubs.clear();
            _devs.clear();
            _snByUrl.clear();
            _snByName.clear();
            _fnByType.clear();
            _firstArrival = true;
            _namechgCallback = null;
            _removalCallback = null;
            _apiInitialized = false;
            _calibHandlers.clear();
        }
    }

    public static String GetAPIVersion() {
        return "1.01.11167";
    }

    public static int InitAPI(int mode) {
        YAPI._init_free(false);
        return 0;
    }

    public static void FreeAPI() {
        YAPI._init_free(true);
    }

    public static int RegisterHub(String url) throws YAPI_Exception {
        YAPI._init_free(false);
        if (!url.equalsIgnoreCase("usb")) {
            // empty if block
        }
        YAPI.PreregisterHub(url);
        YAPI._updateDeviceList_internal(true, false);
        return 0;
    }

    public static void EnableUSBHost(Object osContext) throws YAPI_Exception {
        YAPI._init_free(false);
        YUSBHub.SetContextType(osContext);
    }

    public static int PreregisterHub(String url) throws YAPI_Exception {
        YGenericHub newhub;
        YAPI._init_free(false);
        if (!url.contentEquals("usb")) {
            for (YGenericHub h : _hubs) {
                if (!h.isSameRootUrl(url)) continue;
                return 0;
            }
        }
        if (url.equals("usb")) {
            YUSBHub.CheckUSBAcces();
            newhub = new YUSBHub(_hubs.size());
        } else {
            newhub = new YHTTPHub(_hubs.size(), url);
        }
        _hubs.add(newhub);
        newhub.startNotifications();
        return 0;
    }

    public static void UnregisterHub(String url) {
        for (YGenericHub h : _hubs) {
            if (!h.isSameRootUrl(url)) continue;
            h.stopNotifications();
            for (String serial : h._serialByYdx.values()) {
                YAPI.forgetDevice(_devs.get(serial));
            }
            h.release();
            _hubs.remove(h);
            return;
        }
    }

    public static int UpdateDeviceList() throws YAPI_Exception {
        YAPI._init_free(false);
        YAPI._updateDeviceList_internal(false, true);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HandleEvents() {
        YAPI._init_free(false);
        while (true) {
            PendingValue pv;
            Queue<PendingValue> queue = _pendingValues;
            synchronized (queue) {
                if (_pendingValues.isEmpty()) {
                    break;
                }
                pv = _pendingValues.poll();
            }
            pv.fun.advertiseValue(pv.value);
        }
    }

    public static void Sleep(long ms_duration) throws YAPI_Exception {
        long end = YAPI.GetTickCount() + ms_duration;
        YAPI._init_free(false);
        do {
            YAPI.HandleEvents();
            if (end <= YAPI.GetTickCount()) continue;
            try {
                Thread.sleep(3L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(YAPI.class.getName()).log(Level.SEVERE, null, ex);
                throw new YAPI_Exception(-8, "Thread has been interrupted");
            }
        } while (end > YAPI.GetTickCount());
    }

    public static long GetTickCount() {
        return System.currentTimeMillis();
    }

    public static boolean CheckLogicalName(String name) {
        if (name == null) {
            return false;
        }
        if (name.equals("")) {
            return true;
        }
        if (name.length() > 19) {
            return false;
        }
        return name.matches("^[A-Za-z0-9_-]*$");
    }

    public static void RegisterDeviceArrivalCallback(DeviceArrivalCallback arrivalCallback) {
        _arrivalCallback = arrivalCallback;
    }

    public static void RegisterDeviceChangeCallback(DeviceChangeCallback changeCallback) {
        _namechgCallback = changeCallback;
    }

    public static void RegisterDeviceRemovalCallback(DeviceRemovalCallback removalCallback) {
        _removalCallback = removalCallback;
    }

    public static void RegisterLogFunction(LogCallback logfun) {
        _logCallback = logfun;
    }

    public static void Log(String message) {
        if (_logCallback != null) {
            _logCallback.yLog(message);
        }
    }

    static class PlugEvent {
        public Event ev;
        public YModule module;

        public PlugEvent(Event ev, String serial) {
            this.ev = ev;
            this.module = YModule.FindModule(serial + ".module");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Event {
            PLUG,
            UNPLUG,
            CHANGE;

        }
    }

    private static class PendingValue {
        public YFunction fun;
        public String value;

        public PendingValue(YFunction fun, String value) {
            this.fun = fun;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CalibrationHandlerCallback {
        public double yCalibrationHandler(double var1, int var3, ArrayList<Integer> var4, ArrayList<Double> var5, ArrayList<Double> var6);
    }

    public static interface LogCallback {
        public void yLog(String var1);
    }

    public static interface DeviceChangeCallback {
        public void yDeviceChange(YModule var1);
    }

    public static interface DeviceRemovalCallback {
        public void yDeviceRemoval(YModule var1);
    }

    public static interface DeviceArrivalCallback {
        public void yDeviceArrival(YModule var1);
    }
}

