﻿#include<Windows.h>
#include<stdio.h>
#include <string>
#include <iostream>
#include <limits>
#include <stdexcept>
#include "registry.h"
#include "logs.h"

//#define REGISTRYROOT    HKEY_CURRENT_USER
#define REGISTRYROOT    HKEY_LOCAL_MACHINE


void registryStorage::writeIpAddress(std::string address)



{
   
    LONG result = 0;
    LPCWSTR  path = L"Software";
    HKEY hkey;
    long regOpenResult;

    regOpenResult = RegOpenKeyEx(REGISTRYROOT, path, 0, KEY_ALL_ACCESS | KEY_WOW64_64KEY, &hkey);
  

    if (regOpenResult != ERROR_SUCCESS)
    {
      if (regOpenResult == ERROR_ACCESS_DENIED)
      {
        throw std::invalid_argument("Cannot store Hub address in registry, retry with Administrator rights.");
      }


        logs::logErrorOnConsole("RegOpenKeyEx failed", regOpenResult);
        return ;
    }

    HKEY hkey0;
    long regCreateResult = RegCreateKeyEx(hkey, L"Yoctopuce", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS | KEY_WOW64_64KEY, 0, &hkey0, NULL);
    if (regCreateResult != ERROR_SUCCESS)
    {
      logs::logErrorOnConsole("RegCreateKeyEx Yoctopuce failed", regCreateResult);
      return ;
    }



    HKEY hkey2;
     regCreateResult =   RegCreateKeyEx(hkey0, L"Yocto-AudioOuputSwitch",0,NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS | KEY_WOW64_64KEY, 0,&hkey2,NULL);
    if (regCreateResult != ERROR_SUCCESS)
    {
        logs::logErrorOnConsole("RegCreateKeyEx Yocto-AudioOuputSwitch failed", regCreateResult);
        return ;
    }

    std::wstring widestr = std::wstring(address.begin(), address.end());
    const wchar_t* widecstr = widestr.c_str();
    size_t size = sizeof(wchar_t) * address.length();
    long regCreateValueResult  =  RegSetValueEx(hkey2, L"address", 0, REG_SZ,(byte*)widecstr, (DWORD)size);
   
    if (regCreateValueResult != ERROR_SUCCESS)
    {
        logs::logErrorOnConsole("RegSetValueEx failed \n", regCreateValueResult);
        return ;
    }

    RegCloseKey(hkey);  
    RegCloseKey(hkey0);
    RegCloseKey(hkey2);
  
    return ;
}

std::string registryStorage::readIpAddress()
{
 
  LONG     result = 0;
  LPCWSTR  path   = L"Software\\Yoctopuce\\Yocto-AudioOuputSwitch";
  HKEY     hkey;
  long regOpenResult;
  wchar_t  data[512] ;
  DWORD dwBufferSize = sizeof(data);
  

  regOpenResult = RegOpenKeyEx(REGISTRYROOT, path, 0, KEY_READ | KEY_WOW64_64KEY, &hkey);
  if (regOpenResult != ERROR_SUCCESS)
  { 
    return "";
  }

  long nError = RegQueryValueExW(hkey, L"address", 0, NULL, (LPBYTE)data, &dwBufferSize);
  RegCloseKey(hkey);
  if (nError != ERROR_SUCCESS)
  {
     return "";
  }


  

  //convert from wide char to narrow char array
  char ch[512];
  char DefChar = ' ';
  WideCharToMultiByte(CP_ACP, 0, data, -1, ch, 512, &DefChar, NULL);
  std::string ss(ch); 
  return ss;
  


}


