#pragma once
#include <windows.h>
#include <cstdlib>
#include <iostream>
#include <sysinfoapi.h>

#include <yocto_api.h>
#include <yocto_quadraturedecoder.h>
#include <yocto_display.h>
#include <yocto_anbutton.h>
#include <yocto_colorledcluster.h>
#include <yocto_hubPort.h>
#include "AudioOutputManager.h"
#include <fstream>

enum YAudioOuputSwitcherStates {ALLOCATED,INIT_DONE,READY};

class YAudioOuputSwitcher
{
private:
  string initdone;
  YAudioOuputSwitcherStates state;
  YDisplayLayer* layer1;
  YDisplayLayer* layer2;
  YDisplay* display;
  YColorLedCluster* leds;
  BOOL RefreshNeeded = TRUE;
  ULONGLONG lastVolumeChange = 0;
  ULONGLONG lastLedsReset = 0;
  ULONGLONG lastRefesh =0;
  AudioOutputManager* manager;
  std::ofstream logfile;
  void configure_ledWatchdog();
  void refresh(AudioOutputManager* manager);
  void manageLeds();
  
public:
  void BTN_muteChange(YAnButton* fct, const string& value);
  void QD_out_change(YQuadratureDecoder* fct, const string& value);
  void QD_Vol_change(YQuadratureDecoder* fct, const string& value);
  void change(AudioOutputManager* source, ChangeCause cause);
  void deviceArrival(YModule* m);
  
  void init(std::string ipaddress);

  YAudioOuputSwitcher();
  ~YAudioOuputSwitcher();

  int Run();
};

