



using System;
using System.ServiceModel;
using System.ServiceModel.Description;


using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net.Mail;
using System.Net.Mime;


/*
 *
 *
 *  The service and the setup UI communicate through a  WCF Service
 *  see Windows Communication Foundation/ Getting Started Tutorial on MSDN
 *  http://msdn.microsoft.com/en-us/library/ms734712
 *  
 *  if you add/remove/modify calls in IThermalControl you will have
 *  to run the followin command from a  visual studio command prompt
 *  in the  UI directory
 *  svcutil.exe /language:cs /out:generatedProxy.cs /config:app.config http://localhost:4445/ThermalControl
 *  
 *  this will generate the matching code (eneratedProxy.cs & app.config)
 *  used by set Setup UI
 */
[ServiceContract]
public interface IThermalControl
{


    [OperationContract]
    bool setMailSrvAddr(string mailSrvAddr, ref string errmsg);

    [OperationContract]
    bool getMailSrvAddr(ref string value, ref string errmsg);

    [OperationContract]
    bool setMailSrvUsername(string mailSrvUsername, ref string errmsg);

    [OperationContract]
    bool getMailSrvUsername(ref string value, ref string errmsg);

    [OperationContract]
    bool setMailSrvPassword(string mailSrvPassword, ref string errmsg);

    [OperationContract]
    bool setMailNotificationTo(string mailNotificationTo, ref string errmsg);

    [OperationContract]
    bool getMailNotificationTo(ref string value, ref string errmsg);

    [OperationContract]
    bool setMailNotificationSubject(string mailNotificationSubject, ref string errmsg);

    [OperationContract]
    bool getMailNotificationSubject(ref string value, ref string errmsg);

    [OperationContract]
    bool setMailNotificationBody(string mailNotificationBody, ref string errmsg);

    [OperationContract]
    bool getMailNotificationBody(ref string value, ref string errmsg);

    [OperationContract]
    bool setSensorThreshold(double sensorThreshold, ref string errmsg);

    [OperationContract]
    bool getSensorThreshold(ref double value, ref string errmsg);

    [OperationContract]
    bool getSensorValue(ref string sensorname, ref double value, ref string errmsg);

    [OperationContract]
    bool sendTestMail(string MailSrvAddr, string MailSrvUsername, string MailSrvPassword, string MailNotificationTo, ref string errmsg);

}


public class ThermalControlService : IThermalControl
{

    public static string controlURI = "http://localhost:4445/ThermalControl";
   
   

    public bool setMailSrvAddr(string mailSrvAddr, ref string errmsg)
    {
        return ThermalController.setMailSrvAddr(mailSrvAddr, ref  errmsg);
    }

    public bool getMailSrvAddr(ref string value, ref string errmsg)
    {
        return ThermalController.getMailSrvAddr(ref  value, ref  errmsg);
    }

    public bool setMailSrvUsername(string mailSrvUsername, ref string errmsg)
    {
        return ThermalController.setMailSrvUsername(mailSrvUsername, ref  errmsg);
    }

    public bool getMailSrvUsername(ref string value, ref string errmsg)
    {
        return ThermalController.getMailSrvUsername(ref  value, ref  errmsg);
    }

    public bool setMailSrvPassword(string mailSrvPassword, ref string errmsg)
    {
        return ThermalController.setMailSrvPassword(mailSrvPassword, ref  errmsg);
    }

    public bool setMailNotificationTo(string mailNotificationTo, ref string errmsg)
    {
        return ThermalController.setMailNotificationTo(mailNotificationTo, ref  errmsg);
    }

    public bool getMailNotificationTo(ref string value, ref string errmsg)
    {
        return ThermalController.getMailNotificationTo(ref  value, ref  errmsg);
    }

    public bool setMailNotificationSubject(string mailNotificationSubject, ref string errmsg)
    {
        return ThermalController.setMailNotificationSubject(mailNotificationSubject, ref  errmsg);
    }

    public bool getMailNotificationSubject(ref string value, ref string errmsg)
    {
        return ThermalController.getMailNotificationSubject(ref  value, ref  errmsg);
    }

    public bool setMailNotificationBody(string mailNotificationBody, ref string errmsg)
    {
        return ThermalController.setMailNotificationBody(mailNotificationBody, ref  errmsg);
    }

    public bool getMailNotificationBody(ref string value, ref string errmsg)
    {
        return ThermalController.getMailNotificationBody(ref  value, ref  errmsg);
    }


    public bool setSensorThreshold(double sensorThreshold, ref string errmsg)
    {
        return ThermalController.setSensorThreshold(sensorThreshold, ref  errmsg);
    }

    public bool getSensorThreshold(ref double value, ref string errmsg)
    {
        return ThermalController.getSensorThreshold(ref  value, ref  errmsg);
       

    }

    public bool getSensorValue(ref string sensorname, ref double value, ref string errmsg)
    {
        return ThermalController.getSensorValue(ref  sensorname, ref  value, ref  errmsg);
        
    }

    public bool sendTestMail(string MailSrvAddr, string MailSrvUsername, string MailSrvPassword, string  MailNotificationTo , ref string errmsg)
    {   
        
        return ThermalController.sendTestMail(MailSrvAddr,MailSrvUsername,MailSrvPassword,MailNotificationTo, ref  errmsg);

    }



    // just a trick to handle error return
    private bool error(ref string msgvar,  string message)
    {
        msgvar = message;
        return false;
    }


   





}


