<?php
include("yocto_api.php");
include("yocto_genericsensor.php");

define("CRYPTOKEY", "sds213fx!x");     // this is the key used to encrypt data in the inifile, change it!
define("CONFIGFILE", "./config.ini");  // this is the file used to store persistent data, make sure the script can write it
define("MD5PASSWORD","DF23!sa45");     // MD5 password used by Yocto-Hub ethernet, change it as well. 
define("DEFAULTPASSWORD","abcd");      // default password for the UI. 
define("PASSKEY", 'Password');         // internal stuff
define("HISTORICSIZE", 3);             // how many identical values we need to consider it stable

function GetPostValue($key)
 {
  if (array_key_exists($key, $_POST))
    return $_POST[$key];
  if (array_key_exists($key, $_GET))
    return $_GET[$key];
  return "";
 }

function aes_decrypt($val, $ky)
 {
  $key = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
  for ($a = 0; $a < strlen($ky); $a++)
    $key[$a % 16] = chr(ord($key[$a % 16]) ^ ord($ky[$a]));
  $mode = MCRYPT_MODE_ECB;
  $enc  = MCRYPT_RIJNDAEL_128;
  $dec  = @mcrypt_decrypt($enc, $key, base64_decode($val), $mode, @mcrypt_create_iv(@mcrypt_get_iv_size($enc, $mode), MCRYPT_RAND));
  return rtrim($dec, ((ord(substr($dec, strlen($dec) - 1, 1)) >= 0 and ord(substr($dec, strlen($dec) - 1, 1)) <= 16) ? chr(ord(substr($dec, strlen($dec) - 1, 1))) : null));
 }

function aes_encrypt($val, $ky)
 {
  $key = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
  for ($a = 0; $a < strlen($ky); $a++)
    $key[$a % 16] = chr(ord($key[$a % 16]) ^ ord($ky[$a]));
  $mode = MCRYPT_MODE_ECB;
  $enc  = MCRYPT_RIJNDAEL_128;
  $val  = str_pad($val, (16 * (floor(strlen($val) / 16) + (strlen($val) % 16 == 0 ? 2 : 1))), chr(16 - (strlen($val) % 16)));
  return base64_encode(mcrypt_encrypt($enc, $key, $val, $mode, mcrypt_create_iv(mcrypt_get_iv_size($enc, $mode), MCRYPT_RAND)));
 }



function authSendEmail($smtpServer, $port, $from, $namefrom, $username, $password, $to, $nameto, $subject, $message)
 {
  //SMTP + SERVER DETAILS
  /* * * * CONFIGURATION START * * * */
  
  $timeout = "30";
  
  $localhost = $_SERVER["HTTP_HOST"];
  $newLine   = "\r\n";
  /* * * * CONFIGURATION END * * * * */
  
  //Connect to the host on the specified port
  $smtpConnect  = fsockopen($smtpServer, $port, $errno, $errstr, $timeout);
  $smtpResponse = fgets($smtpConnect, 515);
  if (empty($smtpConnect))
   {
    $output = "Failed to connect: $smtpResponse";
    return $output;
   }
  else
   {
    $logArray['connection'] = "Connected: $smtpResponse";
   }
  
  //Request Auth Login
  fputs($smtpConnect, "AUTH LOGIN" . $newLine);
  $smtpResponse            = fgets($smtpConnect, 515);
  $logArray['authrequest'] = "$smtpResponse";
  
  //Send username
  fputs($smtpConnect, base64_encode($username) . $newLine);
  $smtpResponse             = fgets($smtpConnect, 515);
  $logArray['authusername'] = "$smtpResponse";
  
  //Send password
  fputs($smtpConnect, base64_encode($password) . $newLine);
  $smtpResponse             = fgets($smtpConnect, 515);
  $logArray['authpassword'] = "$smtpResponse";
  
  //Say Hello to SMTP
  fputs($smtpConnect, "HELO $localhost" . $newLine);
  $smtpResponse             = fgets($smtpConnect, 515);
  $logArray['heloresponse'] = "$smtpResponse";
  
  //Email From
  fputs($smtpConnect, "MAIL FROM: $from" . $newLine);
  $smtpResponse                 = fgets($smtpConnect, 515);
  $logArray['mailfromresponse'] = "$smtpResponse";
  
  //Email To
  fputs($smtpConnect, "RCPT TO: $to" . $newLine);
  $smtpResponse               = fgets($smtpConnect, 515);
  $logArray['mailtoresponse'] = "$smtpResponse";
  
  //The Email
  fputs($smtpConnect, "DATA" . $newLine);
  $smtpResponse              = fgets($smtpConnect, 515);
  $logArray['data1response'] = "$smtpResponse";
  
  //Construct Headers
  $headers = "MIME-Version: 1.0" . $newLine;
  $headers .= "Content-type: text/html; charset=iso-8859-1" . $newLine;
  $headers .= "To: \"$nameto\" <$to>" . $newLine;
  $headers .= "From: $namefrom <$from>" . $newLine;
  $headers .= "Subject: $subject" . $newLine;
  fputs($smtpConnect, $headers . $newLine . $newLine . $newLine . $message . $newLine . "." . $newLine);
  $smtpResponse              = fgets($smtpConnect, 515);
  $logArray['data2response'] = "$smtpResponse";
  
  // Say Bye to SMTP
  fputs($smtpConnect, "QUIT" . $newLine);
  $smtpResponse             = fgets($smtpConnect, 515);
  $logArray['quitresponse'] = "$smtpResponse";
  
  return $logArray;
 }

function getMailConfigValues()
 {
  return Array(
     // description / key / ispassword?
     Array("RFID key ID:","rfid",false),
     Array("Mail Server:","MailSrv",false),
     Array("Mail Server Port:","MailSrvPort",false),
     Array("Mail Server username:","MailSrvUsername",false),
     Array("Mail Server password:","MailSrvPassword",true),
     Array("From address:","MailFrom",false),
     Array("From Name:","MailFromName",false),
     Array("Send mail to address:","MailTo",false),
     Array("Send mail to (Full name):","MailToName",false),
     Array("Mail Subject:","MailSubject",false),
     Array("Mail Text:","MailMessage",false));
 }

 function SaveConfigToFile($config,&$ermmsg)
 {
  $inifile = "";
  $config['Signature']='**CHECK**';
  foreach ($config as $key => $value)
   {
    if ($value != '')
      $value = aes_encrypt($value, CRYPTOKEY);
    $inifile .= $key . '="' . $value . '"' . "\r\n";
   }
   if (@file_put_contents(CONFIGFILE, $inifile)===false)
   {
    $ermmsg = 'Unable to save '.CONFIGFILE.' file';
    return false;
  }  
  return true;
 }
 
function LoadConfig()
 {
  $keys = Array(PASSKEY,"KeyFound","LastUpdate","Signature");
  for ($i = 0; $i < HISTORICSIZE; $i++)
    $keys[] = sprintf("Historic%d", $i);
  
  $mailConfig = getMailConfigValues();
  for ($i = 0; $i < sizeof($mailConfig); $i++)
    $keys[] = $mailConfig[$i][1];
  
  if (file_exists(CONFIGFILE))
   {
    $config = parse_ini_file(CONFIGFILE);
   }
  else
    $config = Array();
 
  for ($i = 0; $i < sizeof($keys); $i++)
    if (!array_key_exists($keys[$i], $config))
      $config[$keys[$i]] = ''; 
 
  for ($i = 0; $i < sizeof($keys); $i++)
    if ($config[$keys[$i]] != '')
      $config[$keys[$i]] = aes_decrypt($config[$keys[$i]], CRYPTOKEY);

  if ($config['Signature']!='**CHECK**')
    { print("Invalid config signature, revert to default settings");
      for ($i = 0; $i < sizeof($keys); $i++) $config[$keys[$i]] = ''; 
      SaveConfigToFile($config,$ermmsg);
    }
 
  if ($config[PASSKEY] == '')
    $config[PASSKEY] = DEFAULTPASSWORD; // prevent default password to be an empty string
  return $config;
 }




$config = LoadConfig();
if (strpos(strToUpper($_SERVER['HTTP_USER_AGENT']), 'YOCTO') !== false)
 {
  yDisableExceptions();
  if (yRegisterHub("md5:".MD5PASSWORD."@callback", $errmsg) == YAPI_SUCCESS)
   {
    $rfid = yFindGenericSensor("RFID");
    if (!$rfid->isOnline())
      die("no genericSensor called RFID");
    $ID = strtoUpper($rfid->get_advertisedValue());
    $rfid->set_signalRange("-999999.999...999999.999"); // this will reset the current advertised value
    $stable = true;
    $first  = $config["Historic0"];
    for ($i = 1; $i < HISTORICSIZE; $i++)
      if ($config[sprintf("Historic%d", $i)] != $first)
        $stable = false;
    for ($i = 0; $i < HISTORICSIZE - 1; $i++)
      $config[sprintf("Historic%d", $i)] = $config[sprintf("Historic%d", $i + 1)];
    $config[sprintf("Historic%d", HISTORICSIZE - 1)] = $ID;
    $found                                           = 0;
    if ($stable)
     {
      if ($ID == strtoUpper($config['rfid']))
       {
        $found = 1;
        if ($found != intVal($config['KeyFound']))
         {
          Print("key detected, sending mail<br>");
          authSendEmail($config['MailSrv'], $config['MailSrvPort'], $config['MailFrom'], $config['MailFromName'], $config['MailSrvUsername'], $config['MailSrvPassword'], $config['MailTo'], $config['MailToName'], $config['MailSubject'], $config['MailMessage']);
         }
       }
      $config['KeyFound']   = $found;
      $config['LastUpdate'] = time();
     }
    if (!SaveConfigToFile($config,$errmsg)) die ($errmsg);
    die("ok");
   }
  else
    die($errmsg);
 }

?><!doctype html>
<html lang="en">
<head>
<style TYPE="text/css">

BODY
{ font-family: Arial, sans-serif;
  font-size: 14px;
  text-align : justify;
}

input ,textarea, select 
{ border :  1px solid gray;
  border-radius: 2px;
  -moz-border-radius: 2px;
  -webkit-border-top-left-radius:  2px;
  -webkit-border-top-right-radius: 2px;
  -webkit-border-bottom-right-radius:  2px;
  -webkit-border-bottom-left-radius:  2px;
} 

div.datadiv
{   border:3px solid #808080; 
    margin: auto;
    padding: 10px;
    text-align:center;
    border-radius: 10px;
    -moz-border-radius: 10px;
    -webkit-border-top-left-radius:  10px;
    -webkit-border-top-right-radius: 10px;
    -webkit-border-bottom-right-radius:  10px;
    -webkit-border-bottom-left-radius:  10px;  
   
}

 TD.leftCol
 { text-align:right;
   width:50%;
 }     
    
TD.rightCol
 { text-align:left;
   width:50%;
 } 

A.button 
{ border-style: solid;
  border-width : 1px 1px 1px 1px;
  margin-left:5px;
  margin-right:5px;
 
  line-height:32px;
  background-color: #f0f0f0;
  text-decoration : none;
  padding : 4px;
  border-color :gray;
  color: #404040;
  border-radius: 5px;
  -moz-border-radius: 5px;
  -webkit-border-top-left-radius:  5px;
  -webkit-border-top-right-radius: 5px;
  -webkit-border-bottom-right-radius:  5px;
  -webkit-border-bottom-left-radius:  5px;
  
  background-image:url('/img/button_shadow.png');
  background-repeat:repeat-x;
  background-position:left bottom;
}

A:visited.button{
  background-color:  #f0f0f0;
  text-decoration : none;
  color: #404040;
}

A:hover.button
{ background-color:  #E8E8E8;
  text-decoration : none;
  color: #404040;
}

A:active.button
{ background-color : #808080;
  text-decoration : none;
  color: black;
} 
 
TD.logmsg
{ text-align:center;
  font-family:"Courier New", Courier, monospace;
}

</style>

<script>

function postIt(value)
  { document.forms['dataform'].elements['command'].value=value;
    document.forms['dataform'].submit();
  }
 
function message(msg)
  { document.getElementById('MsgContainer').innerHTML=msg;
  }    
 
function configure() {postIt('config');}
function saveConfig() {postIt('saveConfig');}
function cancelConfig() {postIt('');}
function cancelNewPwd() {postIt('');}
function login() {postIt('');}
function testMailConfig() {postIt('testmail');}
function saveNewPwd() 
  { 
    if (document.forms['dataform'].elements['newpwd1'].value!=document.forms['dataform'].elements['newpwd2'].value)
     { message('Error: You did not type new password twice the same.');
       return;
      }
    postIt('saveNewPassword');
  }
function setPassword() {postIt('newpwd');}
</script>

</head>
<body>
<?php
$p       = GetPostValue("p");
$command = GetPostValue("command");
if ($p != $config[PASSKEY])
  $command = 'badpwd';
Print('<table style="position:absolute;width:95%;height:95%" >');
Print('<tr><td colspan=3 height="30%" id="MsgContainer" class="logmsg">&nbsp;');

if ($command == 'saveConfig')
 {
  $data = getMailConfigValues();
  for ($i = 0; $i < sizeof($data); $i++)
    $config[$data[$i][1]] = GetPostValue($data[$i][1]);
  if (!SaveConfigToFile($config,$errmsg))  Print($errmsg); else  Print("New configuration saved");
  $command = '';
 }
if ($command == 'saveNewPassword')
 {
  if (GetPostValue("oldpwd") <> $config[PASSKEY])
    Print("Invalid old password, new password not set.");
  else
   {
    $config[PASSKEY] = GetPostValue("newpwd1");
    if (!SaveConfigToFile($config,$errmsg))  Print($errmsg); else Print("New password set");
   }
  $command = '';
 }

if ($command == 'testmail')
 {
  $data = getMailConfigValues();
  for ($i = 0; $i < sizeof($data); $i++)
    $config[$data[$i][1]] = GetPostValue($data[$i][1]);
  $log = authSendEmail($config['MailSrv'], $config['MailSrvPort'], $config['MailFrom'], $config['MailFromName'], $config['MailSrvUsername'], $config['MailSrvPassword'], $config['MailTo'], $config['MailToName'], 'Test mail for the Key box', 'If you are reading this, then the key box mail configuration fine.');
  Print("<p style='text-align:left'>Mail server connection log:<br>");
  foreach ($log as $key => $value)
    Print("$key: $value<br>");
  Print("</p>"); 
  $command = 'config';
 }

if ($command == 'badpwd')
  if ($p != '')
   {
    Print("bad password");
    sleep(2);
   }

Print('</td></tr><tr><td width="30%"></td><td>');
Printf("<form method='post' name='dataform' target='.'><div class='datadiv'>");
Printf("<input name='p' value='%s' type='hidden'>", htmlspecialchars($p));
Print("<input name='command' value='' type='hidden'>");

switch ($command)
{
  case "":
    $timestamp = intval($config['LastUpdate']);  
    print("<table style='width:100%'>");
    print("<TR><TD colspan=2 style='text-align:center'><h1>Key Box State</h1></td></TR>");
    printf("<TR><TD class='leftCol'>Looking for key ID:</TD><TD class='rightCol'>%s</TD></TR>", htmlspecialchars(strtoupper($config['rfid'])));
    printf("<TR><TD class='leftCol'>Key in the box:</TD><TD class='rightCol'>%s</TD></TR>", (intVal($config['KeyFound']) > 0) ? "Yes" : "no");
    printf("<TR><TD class='leftCol'>Last update:</TD><TD class='rightCol'>%s</TD></TR>", $timestamp > 0 ? gmdate("Y-m-d\TH:i:s\Z", $timestamp) : "N/A");
    printf("<TR><TD class='leftCol'>Send notification mail to:</TD><TD class='rightCol'>%s</TD></TR>", htmlspecialchars($config['MailTo']));
    printf("<TR><TD colspan=2 style='text-align:right'><a class='button' href='javascript:configure();'>Configure</a></TD></TR>");
    print("</table>");
    break;
  case "badpwd":
    print("<h1>Welcome</h1><br>");
    Printf("Password: <input name='p' value='' type='password' autofocus><a href='javascript:login();' class='button'>Login</a><br><br>");
    break;
  case "config":
    print("<table style='width:100%'>");
    print("<TR><TD colspan=2 style='text-align:center'><h1>Configuration</h1></td></TR>");
    $data = getMailConfigValues();
    for ($i = 0; $i < sizeof($data); $i++)
     {
      Print("<tr><td class='leftCol'>" . $data[$i][0] . "</td><td class='rightCol'>");
      Printf("<input name='%s' value='%s' %s", $data[$i][1], htmlspecialchars($config[$data[$i][1]]), $data[$i][2] ? "type='password'" : '');
      Print("</td></tr>\n");
     }
    printf("<TR><TD></TD><TD class='rightCol'><a href='javascript:testMailConfig()'>Test Mail Configuration</a></TD></TR>\n");
    print("</table>\n");
    print("<p style='text-align:right'>");
    print("<a class='button' href='javascript:setPassword();'>Change Password</a>&nbsp;");
    print("<a class='button' href='javascript:saveConfig();'>Save</a>");
    print("<a class='button' href='javascript:cancelConfig();'>Cancel</a>&nbsp;");
    printf("</p>");
    break;
  
  case "newpwd":
    print("<table style='width:100%'>");
    print("<TR><TD colspan=2 style='text-align:center'><h1>Change password</h1></td></TR>");
    printf("<TR><TD class='leftCol'>Old Password:</TD><TD class='rightCol'><input name='oldpwd' value='' type='password'></TD></TR>");
    printf("<TR><TD class='leftCol'>New Password:</TD><TD class='rightCol'><input name='newpwd1' value='' type='password'></TD></TR>");
    printf("<TR><TD class='leftCol'>Retype New Password:</TD><TD class='rightCol'><input name='newpwd2' value='' type='password'></TD></TR>");
    print("</table>\n");
    print("<p style='text-align:right'>");
    print("<a class='button' href='javascript:saveNewPwd() ;'>Save</a>");
    print("<a class='button' href='javascript:cancelNewPwd() ;'>Cancel</a>&nbsp;");
    printf("</p>");
    break;
    
}
Print("</form>");
Print('</td><td width="30%"></td></tr><tr><td colspan=3 height="30%">&nbsp;</td></tr></table>');
?>
</body>
</html>