﻿//
//  this is the active code of the Tilt Keyboard
//  it will check for the tilt sensor orientation, and 
//  emulate keypress based on tilt sensor inclination

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using WindowsInput;
using WindowsInput.Native;
using System.Windows.Forms;

namespace Kb3dTray
{
  class TiltKeyboard
  {
    static InputSimulator sim;
    static Form1 win = null;
    static bool ready = false;
    static int lastUpdateDeviceList = 0;

    // Example 1: emulating arrow keys using a Yocto-3D

    // Set to true if you want the key to be pressed again as long as the Yocto-3D is hold
    // Set to false if you only want one KeyDown and one KeyUp event for each move
    static bool AutoRepeat = false;

    static bool isLeft = false;
    static bool isRight = false;
    static bool isForwd = false;
    static bool isBackwd = false;

    static void YAnglesCallback(YGyro yGyro, double roll, double pitch, double head)
    {
      if(win != null)
      {
          win.RollValue.Text = roll.ToString();
          win.PitchValue.Text = pitch.ToString();
      }

      // Release keys when going back to center position
      if (isLeft && (roll > -20 || AutoRepeat) )
      {
          sim.Keyboard.KeyUp(VirtualKeyCode.LEFT);
          isLeft = false;
      }
      if (isRight && (roll < 20 || AutoRepeat))
      {
          sim.Keyboard.KeyUp(VirtualKeyCode.RIGHT);
          isRight = false;
      }
      if (isForwd && (pitch > -20 || AutoRepeat))
      {
          sim.Keyboard.KeyUp(VirtualKeyCode.UP);
          isForwd = false;
      }
      if (isBackwd && (pitch < 20 || AutoRepeat))
      {
          sim.Keyboard.KeyUp(VirtualKeyCode.DOWN);
          isBackwd = false;
      }

      // Press keys when going away from center position
      if (!isLeft && roll < -30)
      {
          sim.Keyboard.KeyDown(VirtualKeyCode.LEFT);
          isLeft = true;
      }
      if (!isRight && roll > 30)
      {
          sim.Keyboard.KeyDown(VirtualKeyCode.RIGHT);
          isRight = true;
      }
      if (!isForwd && pitch < -30)
      {
          sim.Keyboard.KeyDown(VirtualKeyCode.UP);
          isForwd = true;
      }
      if (!isBackwd && pitch > 30)
      {
          sim.Keyboard.KeyDown(VirtualKeyCode.DOWN);
          isBackwd = true;
      }
    }

    // Example 2: Controlling X-Plane 10 functions using a Yocto-Knob
    //            - input named 'breaks' will drive the breaks (on/off)
    //            - input named 'throttle' will drive the throttles (progressive)

    // Set this parameter to the number of keypress to map for the full span
    static int throttleSteps = 100;

    static int currBreaks = -1;     // unknown
    static int currThrottle = 0;    // assume throttle down
    static VirtualKeyCode VK_MoreThrottle = VirtualKeyCode.F2;
    static VirtualKeyCode VK_LessThrottle = VirtualKeyCode.F1;

    static void YThrottleCallback(YAnButton b, string value)
    {
        int newThrottle = Convert.ToInt32(value) * throttleSteps / 1001;
        int delta = newThrottle - currThrottle;

        if (delta > 0)
        {
            if (newThrottle >= throttleSteps-1) 
            {   // min throttle, add extra steps to be sure
                delta += throttleSteps / 4;
            }
            sim.Keyboard.KeyDown(VK_MoreThrottle);
            sim.Keyboard.Sleep(30 * delta);
            sim.Keyboard.KeyUp(VK_MoreThrottle);
        }
        else if (delta < 0)
        {
            delta = -delta;
            if (newThrottle == 0)
            {   // min throttle, add extra steps to be sure
                delta += throttleSteps / 4;
            }
            sim.Keyboard.KeyDown(VK_LessThrottle);
            sim.Keyboard.Sleep(30 * delta);
            sim.Keyboard.KeyUp(VK_LessThrottle);
        }
        currThrottle = newThrottle;
    }

    static void YBreaksCallback(YAnButton b, string value)
    {
        int newBreaks = Convert.ToInt32(value) / 501;

        if (newBreaks == 1 && currBreaks != 1)
        {
            sim.Keyboard.KeyDown(VirtualKeyCode.LCONTROL);
            sim.Keyboard.KeyPress(VirtualKeyCode.VK_B);
            sim.Keyboard.KeyUp(VirtualKeyCode.LCONTROL);
            currBreaks = 1;
        }
        if (newBreaks == 0 && currBreaks != 0)
        {
            sim.Keyboard.KeyPress(VirtualKeyCode.VK_B);
            currBreaks = 0;
        }
    }

    static void deviceArrival(YModule m)
    {
      string serial = m.get_serialNumber();
      int fctcount = m.functionCount();
      for (int i = 0; i < fctcount; i++)
      {
          if(m.functionId(i) == "gyro") 
          {
              YGyro gyro = YGyro.FindGyro(serial + ".gyro");
              win.Message.Text = "Using " + serial;
              gyro.registerAnglesCallback(YAnglesCallback);
          }
          else if(m.functionName(i) == "breaks") 
          {
              YAnButton button = YAnButton.FindAnButton(serial + "." + m.functionId(i));
              win.Message.Text = "Using " + serial;
              button.registerValueCallback(YBreaksCallback);
          }
          else if (m.functionName(i) == "throttle")
          {
              YAnButton button = YAnButton.FindAnButton(serial + "." + m.functionId(i));
              win.Message.Text = "Using " + serial;
              button.registerValueCallback(YThrottleCallback);
          }
      }
    }

    static void deviceRemoval(YModule m)
    {
        win.Message.Text = m.get_serialNumber() + " unplugged";
    }

    public static void Start(Form1 debugWin)
    {
      string errmsg = "";

      win = debugWin;
      win.Message.Text = "Starting...";
      sim = new InputSimulator();

      // try to register using USB native control
      YAPI.DisableExceptions();
      if (YAPI.RegisterHub("usb", ref errmsg) != YAPI.SUCCESS)
      {
          win.Message.Text = "Error: " + errmsg;
      } 
      else
      {
          win.Message.Text = "Plug a Yocto-3D or Yocto-Knob";
          YAPI.RegisterDeviceArrivalCallback(deviceArrival);
          YAPI.RegisterDeviceRemovalCallback(deviceRemoval);
          YAPI.UpdateDeviceList(ref errmsg);
          YAPI.HandleEvents(ref errmsg);
          ready = true;
      }
    } 
  
    public static void Tick()
    {
      string errmsg = "";

      if (!ready) return;

      lastUpdateDeviceList++;
      if (lastUpdateDeviceList >= 20)
      {
          lastUpdateDeviceList = 0;
          YAPI.UpdateDeviceList(ref errmsg);
      } 

      YAPI.HandleEvents(ref errmsg);
    } 

  }

}
