/*********************************************************************
*
* $Id: cmdline_linker.cpp 53958 2023-04-07 07:33:19Z mvuilleu $
*
* implementation of cmdline  API generic class & functions
*
* - - - - - - - - - License information: - - - - - - - - -
*
* Copyright (C) 2011 and beyond by Yoctopuce Sarl, Switzerland.
*
* 1) If you have obtained this file from www.yoctopuce.com,
*    Yoctopuce Sarl licenses to you (hereafter Licensee) the
*    right to use, modify, copy, and integrate this source file
*    into your own solution for the sole purpose of interfacing
*    a Yoctopuce product with Licensee's solution.
*
*    The use of this file and all relationship between Yoctopuce
*    and Licensee are governed by Yoctopuce General Terms and
*    Conditions.
*
*    THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT
*    WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
*    WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS
*    FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO
*    EVENT SHALL LICENSOR BE LIABLE FOR ANY INCIDENTAL, SPECIAL,
*    INDIRECT OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA,
*    COST OF PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR
*    SERVICES, ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT
*    LIMITED TO ANY DEFENSE THEREOF), ANY CLAIMS FOR INDEMNITY OR
*    CONTRIBUTION, OR OTHER SIMILAR COSTS, WHETHER ASSERTED ON THE
*    BASIS OF CONTRACT, TORT (INCLUDING NEGLIGENCE), BREACH OF
*    WARRANTY, OR OTHERWISE.
*
* 2) If your intent is not to interface with Yoctopuce products,
*    you are not entitled to use, read or create any derived
*    material from this source file.
*
*********************************************************************/
#define _CRT_SECURE_NO_WARNINGS
#include "cmdline_common.h"


#if defined(CMD_YSH) || defined(CMD_YAccelerometer)
#include "YAccelerometer.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YAudioIn)
#include "YAudioIn.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YAudioOut)
#include "YAudioOut.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YAltitude)
#include "YAltitude.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YAnButton)
#include "YAnButton.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YArithmeticSensor)
#include "YArithmeticSensor.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YBluetoothLink)
#include "YBluetoothLink.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YBuzzer)
#include "YBuzzer.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YCarbonDioxide)
#include "YCarbonDioxide.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YCellular)
#include "YCellular.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YColorLed)
#include "YColorLed.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YColorLedCluster)
#include "YColorLedCluster.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YCompass)
#include "YCompass.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YCurrent)
#include "YCurrent.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YCurrentLoopOutput)
#include "YCurrentLoopOutput.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YDaisyChain)
#include "YDaisyChain.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YDataLogger)
#include "YDataLogger.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YDigitalIO)
#include "YDigitalIO.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YDisplay)
#include "YDisplay.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YDualPower)
#include "YDualPower.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YFiles)
#include "YFiles.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YGenericSensor)
#include "YGenericSensor.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YGps)
#include "YGps.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YGroundSpeed)
#include "YGroundSpeed.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YGyro)
#include "YGyro.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YHubPort)
#include "YHubPort.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YHumidity)
#include "YHumidity.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YI2cPort)
#include "YI2cPort.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YInputCapture)
#include "YInputCapture.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YInputChain)
#include "YInputChain.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YLatitude)
#include "YLatitude.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YLongitude)
#include "YLongitude.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YLed)
#include "YLed.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YLightSensor)
#include "YLightSensor.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YMagnetometer)
#include "YMagnetometer.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YMessageBox)
#include "YMessageBox.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YMotor)
#include "YMotor.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YNetwork)
#include "YNetwork.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YPower)
#include "YPower.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YPressure)
#include "YPressure.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YProximity)
#include "YProximity.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YPowerOutput)
#include "YPowerOutput.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YPowerSupply)
#include "YPowerSupply.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YPwmInput)
#include "YPwmInput.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YPwmOutput)
#include "YPwmOutput.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YPwmPowerSource)
#include "YPwmPowerSource.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YQuadratureDecoder)
#include "YQuadratureDecoder.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YRangeFinder)
#include "YRangeFinder.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YRealTimeClock)
#include "YRealTimeClock.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YRefFrame)
#include "YRefFrame.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YRelay)
#include "YRelay.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YSegmentedDisplay)
#include "YSegmentedDisplay.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YSerialPort)
#include "YSerialPort.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YServo)
#include "YServo.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YSpiPort)
#include "YSpiPort.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YStepperMotor)
#include "YStepperMotor.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YMultiAxisController)
#include "YMultiAxisController.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YMultiCellWeighScale)
#include "YMultiCellWeighScale.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YMultiSensController)
#include "YMultiSensController.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YTemperature)
#include "YTemperature.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YTilt)
#include "YTilt.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YTvoc)
#include "YTvoc.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YVoc)
#include "YVoc.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YVoltage)
#include "YVoltage.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YVoltageOutput)
#include "YVoltageOutput.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YWakeUpMonitor)
#include "YWakeUpMonitor.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YWakeUpSchedule)
#include "YWakeUpSchedule.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YWatchdog)
#include "YWatchdog.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YWeighScale)
#include "YWeighScale.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YWireless)
#include "YWireless.h"
#endif

#if defined(CMD_YSH) || defined(CMD_YSensor)
#include "YSensor.h"
#endif
#if defined(CMD_YSH) || defined(CMD_YModule)
#include "YModule.h"
#endif

#define ANY_FUNCTION_LINKED 0

void linkYFunctionsCmdLine(vector<YFunctionCmdLine*> *allCmdlines)
{
    // register specific commands
#if defined(CMD_YSH) || defined(CMD_YAccelerometer)
    allCmdlines->push_back(new YAccelerometerCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YAudioIn)
    allCmdlines->push_back(new YAudioInCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YAudioOut)
    allCmdlines->push_back(new YAudioOutCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YAltitude)
    allCmdlines->push_back(new YAltitudeCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YAnButton)
    allCmdlines->push_back(new YAnButtonCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YArithmeticSensor)
    allCmdlines->push_back(new YArithmeticSensorCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YBluetoothLink)
    allCmdlines->push_back(new YBluetoothLinkCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YBuzzer)
    allCmdlines->push_back(new YBuzzerCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YCarbonDioxide)
    allCmdlines->push_back(new YCarbonDioxideCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YCellular)
    allCmdlines->push_back(new YCellularCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YColorLed)
    allCmdlines->push_back(new YColorLedCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YColorLedCluster)
    allCmdlines->push_back(new YColorLedClusterCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YCompass)
    allCmdlines->push_back(new YCompassCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YCurrent)
    allCmdlines->push_back(new YCurrentCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YCurrentLoopOutput)
    allCmdlines->push_back(new YCurrentLoopOutputCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YDaisyChain)
    allCmdlines->push_back(new YDaisyChainCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YDataLogger)
    allCmdlines->push_back(new YDataLoggerCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YDigitalIO)
    allCmdlines->push_back(new YDigitalIOCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YDisplay)
    allCmdlines->push_back(new YDisplayCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YDualPower)
    allCmdlines->push_back(new YDualPowerCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YFiles)
    allCmdlines->push_back(new YFilesCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YGenericSensor)
    allCmdlines->push_back(new YGenericSensorCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YGps)
    allCmdlines->push_back(new YGpsCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YGroundSpeed)
    allCmdlines->push_back(new YGroundSpeedCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YGyro)
    allCmdlines->push_back(new YGyroCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YHubPort)
    allCmdlines->push_back(new YHubPortCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YHumidity)
    allCmdlines->push_back(new YHumidityCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YI2cPort)
    allCmdlines->push_back(new YI2cPortCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YInputCapture)
    allCmdlines->push_back(new YInputCaptureCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YInputChain)
    allCmdlines->push_back(new YInputChainCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YLatitude)
    allCmdlines->push_back(new YLatitudeCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YLongitude)
    allCmdlines->push_back(new YLongitudeCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YLed)
    allCmdlines->push_back(new YLedCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YLightSensor)
    allCmdlines->push_back(new YLightSensorCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YMagnetometer)
    allCmdlines->push_back(new YMagnetometerCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YMessageBox)
    allCmdlines->push_back(new YMessageBoxCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YMotor)
    allCmdlines->push_back(new YMotorCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YMultiAxisController)
    allCmdlines->push_back(new YMultiAxisControllerCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YMultiCellWeighScale)
    allCmdlines->push_back(new YMultiCellWeighScaleCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YMultiSensController)
    allCmdlines->push_back(new YMultiSensControllerCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YNetwork)
    allCmdlines->push_back(new YNetworkCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YPower)
    allCmdlines->push_back(new YPowerCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YPressure)
    allCmdlines->push_back(new YPressureCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YProximity)
    allCmdlines->push_back(new YProximityCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YPowerOutput)
    allCmdlines->push_back(new YPowerOutputCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YPowerSupply)
    allCmdlines->push_back(new YPowerSupplyCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YPwmInput)
    allCmdlines->push_back(new YPwmInputCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YPwmOutput)
    allCmdlines->push_back(new YPwmOutputCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YPwmPowerSource)
    allCmdlines->push_back(new YPwmPowerSourceCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YQuadratureDecoder)
    allCmdlines->push_back(new YQuadratureDecoderCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YRangeFinder)
    allCmdlines->push_back(new YRangeFinderCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YRealTimeClock)
    allCmdlines->push_back(new YRealTimeClockCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YRefFrame)
    allCmdlines->push_back(new YRefFrameCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YRelay)
    allCmdlines->push_back(new YRelayCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YSegmentedDisplay)
    allCmdlines->push_back(new YSegmentedDisplayCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YSerialPort)
    allCmdlines->push_back(new YSerialPortCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YServo)
    allCmdlines->push_back(new YServoCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YSpiPort)
    allCmdlines->push_back(new YSpiPortCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YStepperMotor)
    allCmdlines->push_back(new YStepperMotorCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YTemperature)
    allCmdlines->push_back(new YTemperatureCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YTilt)
    allCmdlines->push_back(new YTiltCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YTvoc)
    allCmdlines->push_back(new YTvocCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YVoc)
    allCmdlines->push_back(new YVocCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YVoltage)
    allCmdlines->push_back(new YVoltageCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YVoltageOutput)
    allCmdlines->push_back(new YVoltageOutputCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YWakeUpMonitor)
    allCmdlines->push_back(new YWakeUpMonitorCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YWakeUpSchedule)
    allCmdlines->push_back(new YWakeUpScheduleCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YWatchdog)
    allCmdlines->push_back(new YWatchdogCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YWeighScale)
    allCmdlines->push_back(new YWeighScaleCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YWireless)
    allCmdlines->push_back(new YWirelessCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YModule)
    allCmdlines->push_back(new YModuleCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

#if defined(CMD_YSH) || defined(CMD_YSensor)
    allCmdlines->push_back(new YSensorCmdLine());
#   undef ANY_FUNCTION_LINKED
#   define ANY_FUNCTION_LINKED 1
#endif

}

#if ANY_FUNCTION_LINKED == 0
#   error "Missing function definition in cmdline_linker.cpp !"
#endif
