﻿
//
//  Very basic mail checked using ImapX library (see http://hellowebapps.com/products/imapx/)
//  and  Yocto-PowerColor / Yocto-Color    module (see  http://www.yoctopuce.com/EN/products/yocto-powercolor)
//

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ImapX;

namespace WindowsFormsApplication1
{
  public partial class Form1 : Form
  {
    public Form1()
    {
      InitializeComponent();
      foreach (string arg in Environment.GetCommandLineArgs())
      {
        if (arg.Substring(0, 2) == "s=") server.Text = arg.Substring(2);
        if (arg.Substring(0, 2) == "u=") username.Text = arg.Substring(2);
        if (arg.Substring(0, 2) == "p=") password.Text = arg.Substring(2);

      }
      timer1.Interval = 1000;
      timer1.Enabled = true;

      string execname = System.AppDomain.CurrentDomain.FriendlyName;
     
      log("usage: ");
      log("execname s=MailServer u=username p=password");
      log("");
    }

    public void log(string msg)
    {
      textBox1.AppendText(msg + Environment.NewLine);
    }

    private void checkForNewMail()
     {
      if (server.Text=="") return;
      if (username.Text=="") return;
      if (password.Text=="") return;

      log("Checking...");

      // connect to the mail server
      ImapX.ImapClient client = new ImapX.ImapClient(server.Text, 143, false);

      bool result = false;
      result = client.Connection();

      if (!result)
      { log("Connection failed");
        return ;
      }

      log("Connected");

      // logon
      result = client.LogIn(username.Text, password.Text);

      if (!result)
      { log("Login failed");
        return  ;
      }

      log("Login ok");

      // retreive messages
      ImapX.MessageCollection messages = client.Folders["INBOX"].Messages;

      log(messages.Count+" mails found in inbox");

      // count unread messages
      int UnreadMessages = 0;
      for (int i = 0; i < messages.Count; i++)
      { messages[i].ProcessFlags();
        if (!messages[i].Flags.Contains(ImapFlags.SEEN))  UnreadMessages++;
      }

      log(UnreadMessages + " unread messages");
      client.LogOut();

      // update the led status, We look for a led with logical name
      // set to "MailIndicator" (the function  name, not the
      // Module name)
      YColorLed led = YColorLed.FindColorLed("MailIndicator");
      if (led.isOnline())
        led.rgbMove(UnreadMessages > 0 ? 0xFF0000 : 0x00FF00, 1000);
      else
        log("No 'MailIndicator' led found");
    }

    private void button1_Click(object sender, EventArgs e)
    {
      button1.Enabled = false;
      checkForNewMail();
      button1.Enabled = true;
    }

    private void timer1_Tick(object sender, EventArgs e)
    {
      button1.Enabled = false;
      timer1.Enabled = false;
      checkForNewMail();
      timer1.Interval = 300000;  // 5 minutes until next check
      timer1.Enabled = true;
      button1.Enabled = true;
    }

  }
}
