<?php
// library for handling waveshare 4.3" e-paper display
// with a Yocto-Serial through PHP

function SendCommand($serialPort,$cmd,$param)
{  $frame = Array(0xA5,0,0,$cmd);
    if (!is_null($param))
       $frame= array_merge($frame,$param);
    $frame[]=0xCC;
    $frame[]=0x33;
    $frame[]=0xC3;
    $frame[]=0x3C;
    $frame[1] = ((sizeof($frame)+1) >>8) & 0xff;
    $frame[2] = (sizeof($frame)+1)  & 0xff;

    $checksum = $frame[0];
    for ($i=1; $i<sizeof($frame);$i++) $checksum ^= $frame[$i];
    $frame[]=$checksum;
    $serialPort->writeArray($frame);
 
   return true;    
}

function handShake($serialPort)
{   return SendCommand($serialPort,0,NULL);
}

function refreshAndUpdate($serialPort)
{   return SendCommand($serialPort,0xA,NULL);
}

function clearWithBgColor($serialPort)
{   return SendCommand($serialPort,0x2E,NULL);
}

function drawPoint($serialPort,$x,$y)
{  return sendCommand($serialPort,0x20,Array(($x>>8)&0xff,$x&0xff,($y>>8)&0xff,$y&0xff));
}

function drawLine($serialPort,$x1,$y1,$x2,$y2)
{  return sendCommand($serialPort,0x22,Array(($x1>>8)&0xff,$x1&0xff,($y1>>8)&0xff,$y1&0xff,($x2>>8)&0xff,$x2&0xff,($y2>>8)&0xff,$y2&0xff));
}

function fillRect($serialPort,$x1,$y1,$x2,$y2)
{ return sendCommand($serialPort,0x24,Array(($x1>>8)&0xff,$x1&0xff,($y1>>8)&0xff,$y1&0xff,($x2>>8)&0xff,$x2&0xff,($y2>>8)&0xff,$y2&0xff));
}

function DrawRect($serialPort,$x1,$y1,$x2,$y2)
{ return sendCommand($serialPort,0x25,Array(($x1>>8)&0xff,$x1&0xff,($y1>>8)&0xff,$y1&0xff,($x2>>8)&0xff,$x2&0xff,($y2>>8)&0xff,$y2&0xff));
}

function fillCircle($serialPort,$x,$y,$r)
{ return sendCommand($serialPort,0x27,Array(($x>>8)&0xff,$x&0xff,($y>>8)&0xff,$y&0xff,($r>>8)&0xff,$r&0xff));
}

function drawCircle($serialPort,$x,$y,$r)
{ return sendCommand($serialPort,0x26,Array(($x>>8)&0xff,$x&0xff,($y>>8)&0xff,$y&0xff,($r>>8)&0xff,$r&0xff));
}

function fillTriangle($serialPort,$x1,$y1,$x2,$y2,$x3,$y3)
{ return sendCommand($serialPort,0x29,Array(($x1>>8)&0xff,$x1&0xff,($y1>>8)&0xff,$y1&0xff,($x2>>8)&0xff,$x2&0xff,($y2>>8)&0xff,$y2&0xff,($x3>>8)&0xff,$x3&0xff,($y3>>8)&0xff,$y3&0xff));
}

function set32PtFont($serialPort)
 { return SendCommand($serialPort,0x1E, Array(1));
 }

function set48PtFont($serialPort)
 { return SendCommand($serialPort,0x1E, Array(2));
 }

function set64PtFont($serialPort)
 {  return SendCommand($serialPort,0x1E, Array(3));
 }

function setDrawingColor($serialPort,$fg,$bg)
 { return SendCommand($serialPort,0x10, Array($fg&3,$bg&3));
 }
 
function setOrientationNormal($serialPort)
 {  return SendCommand($serialPort,0xD, Array(0));
 }
 function setOrientation180($serialPort)
 {  return SendCommand($serialPort,0xD, Array(1));
 } 
 
 function setStorageNandFlash($serialPort)
 {  return SendCommand($serialPort,0x6, Array(0));
 
 } 
 
function setStorageMicroSD($serialPort)
 {  return SendCommand($serialPort,0x6, Array(1));
 
 } 

function ImportImageLibrary($serialPort)
 {  return SendCommand($serialPort,0xf, Null);
 
 }  
 
function drawTriangle($serialPort,$x1,$y1,$x2,$y2,$x3,$y3)
{ return sendCommand($serialPort,0x28,Array(($x1>>8)&0xff,$x1&0xff,($y1>>8)&0xff,$y1&0xff,($x2>>8)&0xff,$x2&0xff,($y2>>8)&0xff,$y2&0xff,($x3>>8)&0xff,$x3&0xff,($y3>>8)&0xff,$y3&0xff));
}

function drawText($serialPort,$x,$y,$text)
{  
   $text=substr($text,0,1020);
   $p = Array(($x>>8)&0xff,$x&0xff,($y>>8)&0xff,$y&0xff);
   for ($i=0;$i<strlen($text);$i++)
     $p[]= ord($text[$i]);
   $p[]=0;
   return sendCommand($serialPort,0x30,$p);
} 

function drawImage($serialPort,$x,$y,$filename)
{  $filename=substr($filename,0,10);
   $p = Array(($x>>8)&0xff,$x&0xff,($y>>8)&0xff,$y&0xff);
   for ($i=0;$i<strlen($filename);$i++)
     $p[]= ord($filename[$i]);
   $p[]=0;
   return sendCommand($serialPort,0x70,$p);
}

?>