
(*
  -------------------------------------------------------------------------
  Yoctopuce screen saver. Shut down the computer after a given time and
  controls a desklamp with a Yocto-Relay and a Yocto-Volt. For more info
  see  www.yoctopuce.com/EN/article/how-to-control-a-desk-lamp-through-usb
  --------------------------------------------------------------------------
  This contain configuration saving/restore routines ans windows shut
  down routine


*)

unit kernel;



interface
 var
  timeout :integer;
  forceshutdown:boolean;
  VlogicName : string;
  R1logicName : string;
  R2logicName : string;
  lampOffWhenStart : boolean;
  lampOffWhenShutdown : boolean;

 procedure saveConfig();
 procedure PowerOffWindows(force:boolean);

implementation
uses windows,registry;

const
   regpath =   'SOFTWARE\YoctoScreeenSaver';

procedure loadConfig();
  var
    r:tregistry;
  begin
    timeout := 60;
    forceshutdown   := false;
    VlogicName  := 'DeskLampV';
    R1logicName := 'DeskLampR1';
    R2logicName := 'DeskLampR2';
    lampOffWhenStart :=true;
    lampOffWhenShutdown :=true;

    r:=tregistry.create();
    r.rootkey := HKEY_LOCAL_MACHINE;
    r.openkey(regpath,true);
    if r.valueExists('timeout') then timeout:=r.readinteger('timeout');
    if r.valueExists('force')   then forceshutdown:=r.readbool('force');
    if r.valueExists('VlogicName') then VlogicName:=r.readstring('VlogicName');
    if r.valueExists('R1logicName')   then R1logicName:=r.readstring('R1logicName');
    if r.valueExists('R2logicName')   then R2logicName:=r.readstring('R2logicName');
    if r.valueExists('lampOffWhenStart')   then lampOffWhenStart:=r.readbool('lampOffWhenStart');
    if r.valueExists('lampOffWhenShutdown')   then lampOffWhenShutdown:=r.readbool('lampOffWhenShutdown');

    r.free;
  end;

procedure saveConfig();
   var
    r:tregistry;
   begin
    r:=tregistry.create();
    r.rootkey := HKEY_LOCAL_MACHINE;
    r.openkey(regpath,true);
    r.writeinteger('timeout',timeout);
    r.writebool('forceshutdown',forceshutdown);
    r.writestring('VlogicName',VlogicName);
    r.writestring('R1logicName',R1logicName);
    r.writestring('R2logicName',R2logicName);
    r.writebool('lampOffWhenStart',lampOffWhenStart);
    r.writebool('lampOffWhenShutdown',lampOffWhenShutdown);


    r.free;
   end;

procedure PowerOffWindows(force:boolean);
  var hToken: THandle;
      tkp, p: TTokenPrivileges;
      RetLen: DWord;
      Reply: DWord;
      flags : DWORD;
 begin
  if OpenProcessToken(GetCurrentProcess, TOKEN_ADJUST_PRIVILEGES or TOKEN_QUERY, hToken) then
   begin
     if LookupPrivilegeValue(nil, 'SeShutdownPrivilege', tkp.Privileges[0].Luid) then
     begin
      tkp.PrivilegeCount := 1;
      tkp.Privileges[0].Attributes := SE_PRIVILEGE_ENABLED;
      AdjustTokenPrivileges(hToken, False, tkp, SizeOf(TTokenPrivileges), p, RetLen);
      Reply := GetLastError;
      flags :=  EWX_POWEROFF;
      if force then flags:= flags or EWX_FORCE;
      if Reply = ERROR_SUCCESS then ExitWindowsEx(flags, 0);
    end;
  end;
end;


initialization

   loadConfig();
  
end.
