unit desklamp;



(*
  -------------------------------------------------------------------------
  Yoctopuce screen saver. Shut down the computer after a given time and
  controls a desklamp with a Yocto-Relay and a Yocto-Volt. For more info
  see  www.yoctopuce.com/EN/article/how-to-control-a-desk-lamp-through-usb
  --------------------------------------------------------------------------
  This is desk lmap control part


*)

interface

uses  Classes, Sysutils,yocto_api,Yocto_relay,yocto_voltage;

type
TDeskLampControlDone = procedure(success:boolean; msg:string) of object;

// since  lamp control requires sone delays, control
// is executed from a thread
TDeskLampControl = class(TThread)
 private
  state          : boolean;
  doneCallBack   : TDeskLampControlDone ;
  VoltSensorName : string;
  Relay1Name     : string;
  Relay2Name     : string;
  isDone :boolean;
 private
  Procedure Done(mustfree:boolean;ok:boolean;msg:string);

 public
  constructor create(VlogicName,R1logicName,R2LogicName:string;state:boolean; doneCallBack :TDeskLampControlDone );
  Procedure Execute(); override;
  function isCompleted():boolean;
end;

function LampWasOn():boolean;

implementation
var
 last : integer = 0;
  lastLampState : boolean = false;

function LampWasOn():boolean;
 begin
   LampWasOn :=lastLampState;
 end;

 function TDeskLampControl.isCompleted():boolean;
 begin
   isCompleted :=isdone;
 end;

 constructor TDeskLampControl.create(VlogicName,R1logicName,R2LogicName:string;state:boolean; doneCallBack:TDeskLampControlDone) ;
  begin
    inherited create(false);
    self.state:=state;
    self.doneCallBack:=doneCallBack;
    self.VoltSensorName  :=VlogicName;
    self.Relay1Name      :=R1logicName;
    self.Relay2Name      :=R2LogicName;
    isdone:=false;
  end;

Procedure TDeskLampControl.Done(mustfree:boolean;ok:boolean;msg:string);
 begin
  if   assigned(doneCallBack) then doneCallBack(ok,msg);
  if mustfree then  yfreeApi();
  isdone:=true;
 end;



Procedure TDeskLampControl.Execute();
  var
   errmsg    : string;
   v         : TYvoltage;
   R         : TYRelay;
   i,nbtry   : integer;
   voltage   : double;
  begin
   YdisableExceptions();

   // we try to gain API  control first through a virtual hub if one
   // running, then through USB if no virtual hub found

   if (yRegisterHub('127.0.0.1',errmsg)<>YAPI_SUCCESS) then
    begin
     yunregisterhub('127.0.0.1');
     if (yRegisterHub('usb',errmsg)<>YAPI_SUCCESS) then
      begin
       Done(false,false,'Unable to init Yocto-API: '+errmsg);
       exit;
      end;
    end;

   // look for the voltage sensor
   V:= yFindVoltage(VoltSensorName);
    if not(v.isOnline()) then
      begin
       Done(true,false,'No online '+VoltSensorName+' Volt function');
       exit;
      end;

   voltage :=   abs(V.get_CurrentValue());

   // check lamp state
   lastLampState :=  (voltage>9);
   if ((voltage>9) and state) then
       begin
         Done(true,true,'Already ON');
         exit;
       end;

    if ((voltage<9) and not(state)) then
       begin
         Done(true,true,'Already OFF');
         exit;
       end;


    // look for the relays
    if last = 1 then R:= yFindRelay(Relay1Name) else R:=yFindRelay(Relay2Name);
    last   := 1-last;

    if not(R.isOnline) then
      begin
          Done(true,false,'No online '+Relay1Name+' relay function');
          exit;
      end;

    // try  to activetave one relay, if no lamp
    // change, then try the second one
     for i:=1 to 2 do
      begin
       r.pulse(10);
       ysleep(250,errmsg);
       nbtry:= 0;

       // relay activivation may have cause a brief module deconnection,
       // make sure they are back online
       while not(V.isOnline()) and (nbtry<20) do
        begin
         ysleep(250,errmsg);
         yUpdateDeviceList(errmsg);
         inc(nbtry);
        end;

       // look like the devices died :-(
       if not(V.isOnline()) then
         begin
            Done(true,false,VoltSensorName+' went offline');
            exit;
         end;

       // if voltage is correct, then it's ok
       voltage :=   abs(V.get_CurrentValue());
       if      ((voltage<6) and not(state))
           or  ((voltage>=6) and state)  then
         begin
           Done(true,true,'Done');
           exit;
         end;

      // no change on voltage, lets try the other relay
      if last = 1 then R:= yFindRelay(Relay1Name) else R:=yFindRelay(Relay2Name);
      last   := 1-last;

       nbtry:= 0;

      // make sure the second relay is online
      while not(R.isOnline()) and (nbtry<20) do
        begin
         ysleep(250,errmsg);
         yUpdateDeviceList(errmsg);
         inc(nbtry);
        end;


       if not(R.isOnline()) then
         begin
           Done(true,false,'No online '+Relay2Name+' relay function');

           exit;
         end;
      end;

     // action on both relay didn't cause any voltage chenge,
     //  something's wrong
     Done(true,false,'didn''t work, sorry');

  end;


end.
