
/*
 *
 *
 */


#include <fstream>
#include <ShlObj_core.h>
#include <Shlwapi.h>
#include <time.h>
#include "logs.h"

// #define DEBUG 1


void logs::initLogs(void)
{
  std::wstring path = logs::logFilename();
  if (PathFileExists(path.c_str()))
  {
    std::ofstream logfile;
    logfile.open(path);
    logfile.close();
  }  
  logs::log(L"Log file is "+ path);


}

std::string logs::leadZerosFormat(int num, int width)
{
  std::string tmp = std::string(width, '0') + std::to_string(num);
  return tmp.substr(tmp.length() - width);



}


std::wstring logs::logFilename(void)
{
  TCHAR szPath[512];
  SHGetFolderPath(NULL, CSIDL_COMMON_APPDATA, NULL, 0, szPath);  // Get path for each computer, non-user specific and non-roaming data.
  PathAppend(szPath, L"\\Yoctopuce");
  if (!PathFileExists(szPath))  CreateDirectory(szPath, NULL);
  PathAppend(szPath, L"\\YAudioOutputSwitcher");
  if (!PathFileExists(szPath))  CreateDirectory(szPath, NULL);
  PathAppend(szPath, L"\\log.txt");
  return szPath;
}

void logs::logdebug(std::string line)
 {
#ifdef DEBUG
  std::cout << line;
#endif
 }

void logs::logErrorOnConsole(std::string line)
{
  std::cout << line << " (err=" + std::to_string(GetLastError()) + ")\n";
}


void logs::logErrorOnConsole(std::string line, int err)
{
  std::cout << line << " (err=" + std::to_string(err) + ")\n";
}


void logs::logOnConsole(std::string line)
{
  std::cout << line << "\n";
}




void logs::logerror(std::string line)
{
  logs::log(line+ " (err=" + std::to_string(GetLastError()) + ")");
}

void logs::log(std::wstring wline)
{ 
 
    std::string line(wline.length(), ' ');
    std::copy(wline.begin(), wline.end(), line.begin());
    logs::log(line);
 
}




  void logs::log(std::string line)
{

  std::wstring path = logFilename();
  time_t now = time(NULL);
  tm tm_gmt;
  std::ofstream logfile;

  gmtime_s(&tm_gmt, &now);
  std::string datetime = leadZerosFormat(1900 + tm_gmt.tm_year, 4) + +"-" + leadZerosFormat(tm_gmt.tm_mon, 2) + "-" + leadZerosFormat(tm_gmt.tm_mday, 2)
    + "Z" + leadZerosFormat(tm_gmt.tm_hour, 2) + ":" + leadZerosFormat(tm_gmt.tm_min, 2) + ":" + leadZerosFormat(tm_gmt.tm_sec, 2);


  logfile.open(path, std::ios_base::app);
  logfile << datetime << " " << line << "\n";
  logfile.close();


  std::cout << line << "\n";


}

