#pragma once
#include <windows.h>
#include <string>
#include <mmdeviceapi.h>
#include <comip.h>
#include <vector>
#include <endpointvolume.h>

class AudioOutputManager;
class NotificationClientImplementation2;
class AudioEndpointVolumeNotificationImplementation;

enum ChangeCause { NONE, ENDPOINTCHANGE, VOLUMECHANGE };

typedef void  (*AudioEndPointManagerChangeCallbackPtr)(AudioOutputManager* source, ChangeCause cause);


using std::string;


class AudioEndpoint
{ public:
  std::wstring friendlyName;
  std::wstring deviceid;
  std::wstring description;
  bool isDefault;
public:
  AudioEndpoint(std::wstring  deviceid, std::wstring  friendlyName, std::wstring description, bool isDefault);


};
 
class AudioOutputManager
{

public: 
   AudioOutputManager(AudioEndPointManagerChangeCallbackPtr changeCallback, void* userdata);
   ~AudioOutputManager();
     
   int     get_count(void);
   string  get_FriendlyName(int index);
   int     get_defaultOutput(void);
   void    set_defaultOutputAbs(int index);
   void    set_defaultOutputRel(int index_ofset);
   void    set_volume(float volumeOfset);
   float   get_volume();

   void    set_mute(BOOL state);
   BOOL    get_mute();
   
   void    refresh(ChangeCause cause);
   void    defaultEndPointVolumeChanged(float volume, bool muted);
   void    set_userData(void* data);
   void*    get_userData();

   
private:
   string    initdone;
   float        DefaultEndPointVolume;
   BOOL         DefaultEndPointMuted;
   void*      userData;
   unsigned     m_device_state ;
   EDataFlow    m_device_type  ;
   AudioEndPointManagerChangeCallbackPtr          changeCallback;
   AudioEndpointVolumeNotificationImplementation* volNotification;
   NotificationClientImplementation2*             notifications;
   IAudioEndpointVolume* pEndptVol;
   IMMDeviceEnumerator* pDeviceEnumerator;


   std::vector<AudioEndpoint*> endpoints;
   void SetDefaultEndpointOneRole(std::wstring id);
   void EnumerateEndpoints(IMMDeviceEnumerator* pDeviceEnumerator, unsigned deviceState, EDataFlow deviceFlow);
   IAudioEndpointVolume* get_DefaultAudioEndpointVolume();

};