<?php
//
// script to drive an autonomus solar weather station and a display
//

// Yoctopuce includes
include("yocto_api.php");
include("yocto_temperature.php");
include("yocto_humidity.php");
include("yocto_pressure.php");
include("yocto_display.php");
include("yocto_wakeupmonitor.php");

// database connection, replace DB_* with your own credentials
$conn = mysql_connect(DB_SERVER,DB_USER,DB_PASSWORD);
$res = mysql_select_db(DB_NAME);

// API init, note de the "callback" parameter for HTTP callback  mode 
if (yRegisterHub("callback",$errmsg)!=YAPI_SUCCESS) die($errmsg);

// retreive the feed number if present 
$feed =0;
if (isset($_GET['feed']))  $feed = intval($_GET['feed']);
Print("feed= $feed\n"); 

// retreive the Yoctopuce functions 
$tempSensor=YFindTemperature("METEO.temperature");
$humSenor=YFindHumidity("METEO.humidity");
$pressSensor=YFindPressure("METEO.pressure");
$monitor=YFirstWakeUpMonitor();

$lasTimeStamp =0;
// if a temperature sensor is present, we assume the script
// has been called by the waether station, so we need to store data
if ($tempSensor->isOnline()) 
 {
    $temp = $tempSensor->get_currentValue();
    $hum  = $humSenor->get_currentValue();
    $pre  = $pressSensor->get_currentValue();
 
    $timestamp = time();
    // delete data older then one week.
    mysql_query("delete from weather where feed=$feed and timestamp<".(time()-7*86400));   
    // insert new data
    mysql_query("insert into weather (timestamp,temperature,humidity,pressure,feed) values ($timestamp,$temp,$hum,$pre,$feed)");  
    Print("measure ok\n");   
    // if a wake up monitor is present,we assume the weather
    // station is driven by a YoctoHub-Wireless, so lets
    // put it in sleep mode  to save energy   
    if (!is_null($monitor))
    {  Print("Wake up monitor found, going to sleep...\n"); 
       if($monitor->get_powerDuration() != 60) {
         // in the future, if for some reason the YoctoHub-Wireless fail to
         // connect to a wifi network, if will go to sleep mode after one minute.
         $monitor->set_powerDuration(60);
         $monitor->get_module()->saveToFlash();
       }
       $monitor->sleep(1);     
    }
   
 } else Printf("WARNING: No Yocto-Meteo device with METEO logical name\n");

// Display current graph
$display =yFindDisplay('MeteoDisplay');

if ($display->isOnline())
 {
   $history = Array();
   for ($i=0; $i<128;$i++)
    { $history[$i] = array("temp"=>0.0,"hum"=>0.0,"press"=>0.0,"count"=>0);
    }   
   $timestamp = time();
   $lastTemp   = 0;
   $lastHum    = 0;
   $lastPress  = 0;
   $count      = 0;
   $avgTemp    = 0;

   // fetch data from dtatabase, group  by 15 min clusters
   $result = mysql_query("select * from weather where feed=$feed and timestamp>".($timestamp-15*60*128)." order by timestamp");
   if (!$result ) die(mysql_error());
 
   while ($row = mysql_fetch_array($result))
    { $lastTemp   = $row["temperature"];
      $lastHum    = $row["humidity"];
      $lastPress  = $row["pressure"];
      $lasTimeStamp =  $row["timestamp"];
      $index = (int) ($timestamp - $row["timestamp"])/300;
      $history[$index]["temp"]  += $lastTemp;
      $history[$index]["hum"]   += $lastHum ;
      $history[$index]["press"] += $lastPress;
      $history[$index]["count"] += 1;
    
    }

   if ($count>0) $avgTemp=$avgTemp/$count;
     
   // compute average
   $tmin=999;
   $tmax=-999;
   for ($i=0;$i<sizeof($history);$i++)
     if ($history[$i]["count"]>0)
      { $history[$i]["temp"]  =  $history[$i]["temp"]/ $history[$i]["count"];
        $history[$i]["hum"]   =  $history[$i]["hum"]/ $history[$i]["count"];
        $history[$i]["press"] =  $history[$i]["press"]/ $history[$i]["count"];
        if ($history[$i]["temp"] >$tmax) $tmax = $history[$i]["temp"];
        if ($history[$i]["temp"] <$tmin) $tmin = $history[$i]["temp"];
        $avgTemp+=$history[$i]["temp"];
        $count++;
      }
   if ($count>0) $avgTemp =  $avgTemp /$count;  
 
   $width=  $display->get_displayWidth();
   $height= $display->get_displayHeight();
   Printf("Display size = $width*$height \n");

   // will use double buffering
   $layer4 = $display->get_displayLayer(4);
   $layer4->reset();
   $layer4->hide();

   // altitude correction 
   $Z = 430; // weather station altitude, in meter
   if (isset($_GET['alt']))  $Z = intval($_GET['alt']);
   printf("Altitude=$Z m\n");  
   $tempK = $lastTemp + 273.15; // temperature in deg K
   $barometricPress = round($lastPress *pow(($tempK + 0.0065 * $Z)/$tempK, 5.2561));
   
   // display humidity and pressure in the corners
   $layer4->selectFont('Small.yfm');
   $layer4->drawText(0,0,Y_ALIGN_TOP_LEFT,'P:'.$barometricPress);
   $layer4->drawText(0,$height-1,Y_ALIGN_BOTTOM_LEFT,$lastHum.'%');
   
   // if the display is big enough, lets display current time
   if ($height>32) {
     $layer4->drawText($width/2,$height-1,Y_ALIGN_BOTTOM_CENTER,date('H:i'));
   }

   // reframe the graph;
   $middle = $avgTemp;
   print("Avg Temp =$avgTemp\n");
   if (($tmax-$avgTemp)> $height /2) { print("max peak detected\n"); $middle = $max- ($height /2);}
   else if (($avgTemp-$tmin)> $height /2) { print("min peak detected\n");$middle = $min + ($height /2);}
   
   // draws the scale on the right side
   
   $middleScale =5*round($middle/5); 
   print("max=$tmax min=$tmin middle= $middleScale\n");
   for ($i=$middleScale-15 ;$i<=$middleScale+15;$i+=5)
    {$layer4->drawText($width-1, round(($height /2) - 2*($i-$middle)), Y_ALIGN_CENTER_RIGHT,$i);
     $layer4->moveTo($width-14,round(($height /2) - 2*($i-$middle)));
     $layer4->lineTo($width-13,round(($height /2) - 2*($i-$middle)));
    } 
   
   // draws the graph, ignore empty clusters
   $i=0;
   while (($history[$i]["count"]<=0) && ($i<sizeof($history))) $i++;
   if ($i<sizeof($history))
    { $layer4->moveTo( $width-15 , round(($height /2)  -($history[$i]["temp"] - $middle) *2) );
      for ($j=$i+1;$j<sizeof($history);$j++)
       if ($history[$j]["count"]>0) 
         $layer4->lineTo( $width -$j-15, round($height /2  -($history[$j]["temp"] - $middle) *2));
    }

   // if no data available since more than 15 minutes then there is a problem    
   if ((time()- $lasTimeStamp) >900)
   {  $lastTemp = sprintf("No data since %d min",(time()- $lasTimeStamp) /60);
   } else  
   { $lastTemp = sprintf("%2.1f",$lastTemp);
     $layer4->selectFont('Medium.yfm'); 
   }    
   // draws the temperature with a black border 
   $layer4->selectColorPen(0);
   $layer4->drawText($width/2-1,$height/2,Y_ALIGN_CENTER, $lastTemp);
   $layer4->drawText($width/2+1,$height/2,Y_ALIGN_CENTER, $lastTemp);
   $layer4->drawText($width/2,$height/2+1,Y_ALIGN_CENTER, $lastTemp);
   $layer4->drawText($width/2,$height/2-1,Y_ALIGN_CENTER, $lastTemp);
   $layer4->selectColorPen(0xffff);
   $layer4->drawText($width/2,$height/2,Y_ALIGN_CENTER, $lastTemp);
   // double buffering 
   $display->swapLayerContent(3,4);
 } else Printf("WARNING:  No display function with MeteoDisplay logical name\n");
   
?>